/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ReflectionUtils;

public class InjectionMetadata {
    private static final Log logger = LogFactory.getLog(InjectionMetadata.class);
    private final Class<?> targetClass;
    private final Collection<InjectedElement> injectedElements;
    private volatile Set<InjectedElement> checkedElements;

    public InjectionMetadata(Class<?> targetClass, Collection<InjectedElement> elements) {
        this.targetClass = targetClass;
        this.injectedElements = elements;
    }

    public void checkConfigMembers(RootBeanDefinition beanDefinition) {
        LinkedHashSet<InjectedElement> checkedElements = new LinkedHashSet<InjectedElement>(this.injectedElements.size());
        for (InjectedElement element : this.injectedElements) {
            Member member = element.getMember();
            if (beanDefinition.isExternallyManagedConfigMember(member)) continue;
            beanDefinition.registerExternallyManagedConfigMember(member);
            checkedElements.add(element);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Registered injected element on class [" + this.targetClass.getName() + "]: " + element));
        }
        this.checkedElements = checkedElements;
    }

    public void inject(Object target, String beanName, PropertyValues pvs) throws Throwable {
        Collection<InjectedElement> elementsToIterate;
        Collection<InjectedElement> collection = elementsToIterate = this.checkedElements != null ? this.checkedElements : this.injectedElements;
        if (!elementsToIterate.isEmpty()) {
            boolean debug = logger.isDebugEnabled();
            for (InjectedElement element : elementsToIterate) {
                if (debug) {
                    logger.debug((Object)("Processing injected element of bean '" + beanName + "': " + element));
                }
                element.inject(target, beanName, pvs);
            }
        }
    }

    public void clear(PropertyValues pvs) {
        Collection<InjectedElement> elementsToIterate;
        Collection<InjectedElement> collection = elementsToIterate = this.checkedElements != null ? this.checkedElements : this.injectedElements;
        if (!elementsToIterate.isEmpty()) {
            for (InjectedElement element : elementsToIterate) {
                element.clearPropertySkipping(pvs);
            }
        }
    }

    public static boolean needsRefresh(InjectionMetadata metadata, Class<?> clazz) {
        return metadata == null || metadata.targetClass != clazz;
    }

    public static abstract class InjectedElement {
        protected final Member member;
        protected final boolean isField;
        protected final PropertyDescriptor pd;
        protected volatile Boolean skip;

        protected InjectedElement(Member member, PropertyDescriptor pd) {
            this.member = member;
            this.isField = member instanceof Field;
            this.pd = pd;
        }

        public final Member getMember() {
            return this.member;
        }

        protected final Class<?> getResourceType() {
            if (this.isField) {
                return ((Field)this.member).getType();
            }
            if (this.pd != null) {
                return this.pd.getPropertyType();
            }
            return ((Method)this.member).getParameterTypes()[0];
        }

        protected final void checkResourceType(Class<?> resourceType) {
            if (this.isField) {
                Class<?> fieldType = ((Field)this.member).getType();
                if (!resourceType.isAssignableFrom(fieldType) && !fieldType.isAssignableFrom(resourceType)) {
                    throw new IllegalStateException("Specified field type [" + fieldType + "] is incompatible with resource type [" + resourceType.getName() + "]");
                }
            } else {
                Class<?> paramType;
                Class<?> clazz = paramType = this.pd != null ? this.pd.getPropertyType() : ((Method)this.member).getParameterTypes()[0];
                if (!resourceType.isAssignableFrom(paramType) && !paramType.isAssignableFrom(resourceType)) {
                    throw new IllegalStateException("Specified parameter type [" + paramType + "] is incompatible with resource type [" + resourceType.getName() + "]");
                }
            }
        }

        protected void inject(Object target, String requestingBeanName, PropertyValues pvs) throws Throwable {
            if (this.isField) {
                Field field = (Field)this.member;
                ReflectionUtils.makeAccessible(field);
                field.set(target, this.getResourceToInject(target, requestingBeanName));
            } else {
                if (this.checkPropertySkipping(pvs)) {
                    return;
                }
                try {
                    Method method = (Method)this.member;
                    ReflectionUtils.makeAccessible(method);
                    method.invoke(target, this.getResourceToInject(target, requestingBeanName));
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkPropertySkipping(PropertyValues pvs) {
            if (this.skip != null) {
                return this.skip;
            }
            if (pvs == null) {
                this.skip = false;
                return false;
            }
            PropertyValues propertyValues = pvs;
            synchronized (propertyValues) {
                if (this.skip != null) {
                    return this.skip;
                }
                if (this.pd != null) {
                    if (pvs.contains(this.pd.getName())) {
                        this.skip = true;
                        return true;
                    }
                    if (pvs instanceof MutablePropertyValues) {
                        ((MutablePropertyValues)pvs).registerProcessedProperty(this.pd.getName());
                    }
                }
                this.skip = false;
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearPropertySkipping(PropertyValues pvs) {
            if (pvs == null) {
                return;
            }
            PropertyValues propertyValues = pvs;
            synchronized (propertyValues) {
                if (Boolean.FALSE.equals(this.skip) && this.pd != null && pvs instanceof MutablePropertyValues) {
                    ((MutablePropertyValues)pvs).clearProcessedProperty(this.pd.getName());
                }
            }
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            return null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InjectedElement)) {
                return false;
            }
            InjectedElement otherElement = (InjectedElement)other;
            return this.member.equals(otherElement.member);
        }

        public int hashCode() {
            return this.member.getClass().hashCode() * 29 + this.member.getName().hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " for " + this.member;
        }
    }
}

