/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.test.runner.api.PluginUrlClassification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResourcesResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginUrlClassification resolvePluginResourcesFor(PluginUrlClassification pluginUrlClassification) {
        HashSet exportPackages = Sets.newHashSet();
        HashSet exportResources = Sets.newHashSet();
        HashSet privilegedExportedPackages = Sets.newHashSet();
        HashSet privilegedArtifacts = Sets.newHashSet();
        try (URLClassLoader classLoader = new URLClassLoader(pluginUrlClassification.getUrls().toArray(new URL[0]), null);){
            MulePluginModel mulePluginModel;
            this.logger.debug("Loading plugin '{}' descriptor", (Object)pluginUrlClassification.getName());
            URL pluginJsonUrl = classLoader.findResource("META-INF/mule-artifact.json");
            if (pluginJsonUrl == null && (pluginJsonUrl = classLoader.getResource("META-INF/mule-artifact/mule-artifact.json")) == null) {
                throw new IllegalStateException("mule-artifact.json couldn't be found for plugin: " + pluginUrlClassification.getName());
            }
            try (InputStream stream = pluginJsonUrl.openStream();){
                mulePluginModel = (MulePluginModel)new MulePluginModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read extension describer on plugin '%s'", pluginJsonUrl), e);
            }
            mulePluginModel.getClassLoaderModelLoaderDescriptor().ifPresent(classLoaderModelDescriptor -> {
                exportPackages.addAll(classLoaderModelDescriptor.getAttributes().getOrDefault("exportedPackages", new ArrayList()));
                exportResources.addAll(classLoaderModelDescriptor.getAttributes().getOrDefault("exportedResources", new ArrayList()));
                privilegedExportedPackages.addAll(classLoaderModelDescriptor.getAttributes().getOrDefault("privilegedExportedPackages", new ArrayList()));
                privilegedArtifacts.addAll(classLoaderModelDescriptor.getAttributes().getOrDefault("privilegedArtifactIds", new ArrayList()));
            });
            PluginUrlClassification pluginUrlClassification2 = new PluginUrlClassification(pluginUrlClassification.getName(), pluginUrlClassification.getUrls(), pluginUrlClassification.getExportClasses(), pluginUrlClassification.getPluginDependencies(), exportPackages, exportResources, privilegedExportedPackages, privilegedArtifacts);
            return pluginUrlClassification2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

