/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.test.runner.api.DependencyResolver;
import org.mule.test.runner.api.MulePluginBasedLoaderFinder;
import org.mule.test.runner.maven.MavenModelFactory;
import org.mule.test.runner.utils.ExtensionLoaderUtils;

class ExtensionModelLoaderFinder {
    ExtensionModelLoaderFinder() {
    }

    public ExtensionModelLoader findLoaderFromMulePlugin(File extensionMulePluginJson) {
        try {
            MulePluginBasedLoaderFinder finder = new MulePluginBasedLoaderFinder(extensionMulePluginJson);
            return finder.getLoader();
        }
        catch (FileNotFoundException e) {
            return new DefaultJavaExtensionModelLoader();
        }
    }

    public Optional<ExtensionModelLoader> findLoaderByProperty(Artifact plugin, DependencyResolver dependencyResolver, List<RemoteRepository> rootArtifactRemoteRepositories) {
        DefaultArtifact artifact = new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), "pom", plugin.getVersion());
        try {
            ArtifactResult artifactResult = dependencyResolver.resolveArtifact((Artifact)artifact, rootArtifactRemoteRepositories);
            File pomFile = artifactResult.getArtifact().getFile();
            Model mavenProject = MavenModelFactory.createMavenProject(pomFile);
            String id = mavenProject.getProperties().getProperty("testExtensionModelLoaderId");
            return id != null ? Optional.ofNullable(ExtensionLoaderUtils.getLoaderById(id)) : Optional.empty();
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException("Cannot load extension, the artifact: [" + plugin.toString() + "] cannot be resolved", e);
        }
    }
}

