/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T> T getAnnotationAttributeFrom(Class<?> klass, Class<? extends Annotation> annotationClass, String methodName) {
        Object extensions;
        Annotation annotation = klass.getAnnotation(annotationClass);
        try {
            Method method = annotationClass.getMethod(methodName, new Class[0]);
            extensions = annotation != null ? method.invoke((Object)annotation, new Object[0]) : method.getDefaultValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot read default " + methodName + " from " + annotationClass);
        }
        return (T)extensions;
    }

    public static <T> List<T> getAnnotationAttributeFromHierarchy(Class<?> klass, Class<? extends Annotation> annotationClass, String methodName) {
        ArrayList list = new ArrayList();
        for (Class<?> currentClass = klass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            T attributeFrom = AnnotationUtils.getAnnotationAttributeFrom(currentClass, annotationClass, methodName);
            if (attributeFrom == null) continue;
            list.add(attributeFrom);
        }
        ClassUtils.getAllInterfaces(klass).forEach(currentInterfaceClass -> {
            Object attributeFrom = AnnotationUtils.getAnnotationAttributeFrom(currentInterfaceClass, annotationClass, methodName);
            if (attributeFrom != null) {
                list.add(attributeFrom);
            }
        });
        return list;
    }
}

