/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.JreModuleDiscoverer;
import org.mule.runtime.container.internal.MuleModule;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.MuleClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class TestContainerClassLoaderFactory
extends ContainerClassLoaderFactory
implements AutoCloseable {
    private final Set<String> extraBootPackages;
    private final URL[] urls;
    private final URLClassLoader classLoader;

    public TestContainerClassLoaderFactory(List<String> extraBootPackages, URL[] urls) {
        this.extraBootPackages = ImmutableSet.builder().addAll((Iterable)super.getBootPackages()).addAll(extraBootPackages).addAll((Iterable)((MuleModule)new JreModuleDiscoverer().discover().get(0)).getExportedPackages()).build();
        this.urls = urls;
        this.classLoader = new URLClassLoader(urls, null);
    }

    public ArtifactClassLoader createContainerClassLoader(ClassLoader parentClassLoader) {
        List muleModules = (List)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.discoverModules());
        ClassLoaderLookupPolicy containerLookupPolicy = this.getContainerClassLoaderLookupPolicy(muleModules);
        return this.createArtifactClassLoader(parentClassLoader, muleModules, containerLookupPolicy, new ArtifactDescriptor("mule"));
    }

    protected ArtifactClassLoader createArtifactClassLoader(ClassLoader parentClassLoader, List<MuleModule> muleModules, ClassLoaderLookupPolicy containerLookupPolicy, ArtifactDescriptor artifactDescriptor) {
        ArtifactDescriptor containerDescriptor = new ArtifactDescriptor("mule");
        MuleArtifactClassLoader containerClassLoader = new MuleArtifactClassLoader(containerDescriptor.getName(), containerDescriptor, this.urls, parentClassLoader, (ClassLoaderLookupPolicy)new MuleClassLoaderLookupPolicy(Collections.emptyMap(), this.getBootPackages()));
        return this.createContainerFilteringClassLoader((List)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.discoverModules()), (ArtifactClassLoader)containerClassLoader);
    }

    public Set<String> getBootPackages() {
        return this.extraBootPackages;
    }

    public ClassLoaderLookupPolicy getContainerClassLoaderLookupPolicy() {
        return (ClassLoaderLookupPolicy)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> super.getContainerClassLoaderLookupPolicy(this.discoverModules()));
    }

    private List<MuleModule> discoverModules() {
        return new ContainerModuleDiscoverer(Thread.currentThread().getContextClassLoader()).discover();
    }

    @Override
    public void close() {
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

