/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import java.util.HashMap;
import java.util.List;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupStrategy;
import org.mule.test.runner.api.PluginUrlClassification;

public class PluginLookPolicyFactory {
    public ClassLoaderLookupPolicy createLookupPolicy(PluginUrlClassification pluginClassification, List<PluginUrlClassification> pluginClassifications, ClassLoaderLookupPolicy parentLookupPolicies) {
        HashMap<String, ClassLoaderLookupStrategy> pluginsLookupPolicies = new HashMap<String, ClassLoaderLookupStrategy>();
        for (PluginUrlClassification dependencyPluginClassification : pluginClassifications) {
            if (dependencyPluginClassification.getArtifactId().equals(pluginClassification.getArtifactId())) continue;
            ClassLoaderLookupStrategy lookUpPolicyStrategy = this.getClassLoaderLookupStrategy(pluginClassification, dependencyPluginClassification);
            for (String exportedPackage : dependencyPluginClassification.getExportedPackages()) {
                pluginsLookupPolicies.put(exportedPackage, lookUpPolicyStrategy);
            }
        }
        return parentLookupPolicies.extend(pluginsLookupPolicies);
    }

    private ClassLoaderLookupStrategy getClassLoaderLookupStrategy(PluginUrlClassification currentPluginClassification, PluginUrlClassification dependencyPluginClassification) {
        ClassLoaderLookupStrategy parentFirst = currentPluginClassification.getPluginDependencies().contains(dependencyPluginClassification.getName()) ? ClassLoaderLookupStrategy.PARENT_FIRST : ClassLoaderLookupStrategy.CHILD_ONLY;
        return parentFirst;
    }
}

