/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.ServiceResolutionError;

public class IsolatedServiceProviderDiscoverer
implements ServiceProviderDiscoverer {
    private final List<ArtifactClassLoader> serviceArtifactClassLoaders;

    public IsolatedServiceProviderDiscoverer(List<ArtifactClassLoader> serviceArtifactClassLoaders) {
        Preconditions.checkNotNull(serviceArtifactClassLoaders, (String)"serviceArtifactClassLoaders cannot be null");
        this.serviceArtifactClassLoaders = serviceArtifactClassLoaders;
    }

    public List<ServiceProvider> discover() throws ServiceResolutionError {
        LinkedList<ServiceProvider> serviceProviders = new LinkedList<ServiceProvider>();
        for (ArtifactClassLoader serviceArtifactClassLoader : this.serviceArtifactClassLoaders) {
            try {
                String artifactName = (String)serviceArtifactClassLoader.getClass().getMethod("getArtifactId", new Class[0]).invoke((Object)serviceArtifactClassLoader, new Object[0]);
                ClassLoader classLoader = (ClassLoader)serviceArtifactClassLoader.getClass().getMethod("getClassLoader", new Class[0]).invoke((Object)serviceArtifactClassLoader, new Object[0]);
                ServiceProvider serviceProvider = this.instantiateServiceProvider(classLoader, artifactName);
                serviceProviders.add(serviceProvider);
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't discover service from class loader: " + serviceArtifactClassLoader, e);
            }
        }
        return serviceProviders;
    }

    private ServiceProvider instantiateServiceProvider(ClassLoader classLoader, String className) throws ServiceResolutionError {
        Object reflectedObject;
        try {
            reflectedObject = ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> {
                try {
                    return ClassUtils.instanciateClass((String)className, (Object[])new Object[0]);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to create service from class: " + className)), (Throwable)e);
                }
            });
        }
        catch (RuntimeException e) {
            throw new ServiceResolutionError(e.getMessage(), (Throwable)e);
        }
        if (!(reflectedObject instanceof ServiceProvider)) {
            throw new ServiceResolutionError(String.format("Provided service class '%s' does not implement '%s'", className, ServiceProvider.class.getName()));
        }
        return (ServiceProvider)reflectedObject;
    }
}

