/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.registry.DefaultRegistryBroker;
import org.mule.runtime.core.registry.MuleRegistryHelper;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.test.runner.infrastructure.ExtensionsTestInfrastructureDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ExtensionPluginMetadataGenerator {
    private static final String GENERATED_TEST_RESOURCES = "generated-test-resources";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExtensionsTestInfrastructureDiscoverer extensionsInfrastructure;
    private final File generatedResourcesBase;
    private List<ExtensionGeneratorEntry> extensionGeneratorEntries = Lists.newArrayList();

    public ExtensionPluginMetadataGenerator(File baseResourcesFolder) {
        this.extensionsInfrastructure = new ExtensionsTestInfrastructureDiscoverer(this.createExtensionManager());
        this.generatedResourcesBase = this.getGeneratedResourcesBase(baseResourcesFolder);
    }

    private File getGeneratedResourcesBase(File baseResourcesFolder) {
        File generatedResourcesBase = new File(baseResourcesFolder, GENERATED_TEST_RESOURCES);
        generatedResourcesBase.mkdir();
        return generatedResourcesBase;
    }

    private ExtensionManager createExtensionManager() {
        DefaultExtensionManager extensionManager = new DefaultExtensionManager();
        extensionManager.setMuleContext((MuleContext)new DefaultMuleContext(){
            private ErrorTypeRepository errorTypeRepository = ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository();
            private ErrorTypeLocator errorTypeLocator = ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)this.errorTypeRepository);

            public MuleRegistry getRegistry() {
                return new MuleRegistryHelper(new DefaultRegistryBroker((MuleContext)this), (MuleContext)this);
            }

            public ErrorTypeLocator getErrorTypeLocator() {
                return this.errorTypeLocator;
            }

            public ErrorTypeRepository getErrorTypeRepository() {
                return this.errorTypeRepository;
            }
        });
        try {
            extensionManager.initialise();
        }
        catch (InitialisationException e) {
            throw new RuntimeException("Error while initialising the extension manager", e);
        }
        return extensionManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class scanForExtensionAnnotatedClasses(Artifact plugin, List<URL> urls) {
        this.logger.debug("Scanning plugin '{}' for annotated Extension class", (Object)plugin);
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Extension.class));
        try (URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), null);){
            scanner.setResourceLoader((ResourceLoader)new PathMatchingResourcePatternResolver((ClassLoader)classLoader));
            Set extensionsAnnotatedClasses = scanner.findCandidateComponents("");
            if (!extensionsAnnotatedClasses.isEmpty()) {
                if (extensionsAnnotatedClasses.size() > 1) {
                    this.logger.warn("While scanning class loader on plugin '{}' for discovering @Extension classes annotated, more than one found. It will pick up the first one, found: {}", (Object)plugin, (Object)extensionsAnnotatedClasses);
                }
                String extensionClassName = ((BeanDefinition)extensionsAnnotatedClasses.iterator().next()).getBeanClassName();
                try {
                    Class<?> clazz = Class.forName(extensionClassName);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot load Extension class '" + extensionClassName + "'", e);
                }
            }
            this.logger.debug("No class found annotated with {}", (Object)Extension.class.getName());
            Class clazz = null;
            return clazz;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ExtensionModel getExtensionModel(Artifact plugin, Class extensionClass) {
        return this.extensionsInfrastructure.discoverExtension(extensionClass);
    }

    public File generateExtensionManifest(Artifact plugin, Class extensionClass) {
        this.logger.debug("Generating Extension metadata for extension class: '{}'", (Object)extensionClass);
        File generatedResourcesDirectory = new File(this.generatedResourcesBase, plugin.getArtifactId() + File.separator + "META-INF");
        generatedResourcesDirectory.mkdirs();
        ExtensionModel extensionModel = this.getExtensionModel(plugin, extensionClass);
        this.extensionsInfrastructure.generateLoaderResources(extensionModel, generatedResourcesDirectory);
        this.extensionGeneratorEntries.add(new ExtensionGeneratorEntry(extensionModel, generatedResourcesDirectory));
        return generatedResourcesDirectory.getParentFile();
    }

    public void generateDslResources() {
        this.extensionGeneratorEntries.stream().forEach(entry -> this.extensionsInfrastructure.generateDslResources(entry.getResourcesFolder(), entry.getExtensionModel()));
    }

    class ExtensionGeneratorEntry {
        private ExtensionModel runtimeExtensionModel;
        private File resourcesFolder;

        public ExtensionGeneratorEntry(ExtensionModel runtimeExtensionModel, File resourcesFolder) {
            this.runtimeExtensionModel = runtimeExtensionModel;
            this.resourcesFolder = resourcesFolder;
        }

        public ExtensionModel getExtensionModel() {
            return this.runtimeExtensionModel;
        }

        public File getResourcesFolder() {
            return this.resourcesFolder;
        }
    }
}

