/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.infrastructure;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.Describer;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.extension.api.runtime.ExtensionFactory;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslResolvingContext;
import org.mule.runtime.extension.xml.dsl.api.resources.spi.DslResourceFactory;
import org.mule.runtime.module.extension.internal.DefaultDescribingContext;
import org.mule.runtime.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.runtime.module.extension.internal.introspection.describer.AnnotationsBasedDescriber;
import org.mule.runtime.module.extension.internal.introspection.version.StaticVersionResolver;
import org.mule.runtime.module.extension.internal.introspection.version.VersionResolver;
import org.mule.runtime.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.test.runner.infrastructure.ExtensionsTestDslResourcesGenerator;
import org.mule.test.runner.infrastructure.ExtensionsTestLoaderResourcesGenerator;

public class ExtensionsTestInfrastructureDiscoverer {
    private final ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    private final ExtensionFactory extensionFactory = new DefaultExtensionFactory(this.serviceRegistry, this.getClass().getClassLoader());
    private final ExtensionManagerAdapter extensionManager;

    public ExtensionsTestInfrastructureDiscoverer(ExtensionManagerAdapter extensionManagerAdapter) {
        this.extensionManager = extensionManagerAdapter;
    }

    public void discoverExtensions(Describer[] describers, Class<?>[] annotatedClasses) {
        if (ArrayUtils.isEmpty((Object[])describers) && !ArrayUtils.isEmpty((Object[])annotatedClasses)) {
            describers = Arrays.stream(annotatedClasses).map(annotatedClass -> new AnnotationsBasedDescriber(annotatedClass, (VersionResolver)new StaticVersionResolver(MuleManifest.getProductVersion()))).collect(Collectors.toList()).toArray(new Describer[annotatedClasses.length]);
        }
        if (ArrayUtils.isEmpty((Object[])describers)) {
            throw new IllegalStateException("No extension found");
        }
        this.loadExtensionsFromDescribers(this.extensionManager, describers);
    }

    public ExtensionModel discoverExtension(Class<?> annotatedClass, VersionResolver versionResolver) {
        ExtensionModel model = this.loadExtensionModel((Describer)new AnnotationsBasedDescriber(annotatedClass, versionResolver));
        this.extensionManager.registerExtension(model);
        return model;
    }

    public List<GeneratedResource> generateLoaderResources(ExtensionModel extensionModel, File generatedResourcesDirectory) {
        this.createManifestFileIfNecessary(generatedResourcesDirectory);
        ExtensionsTestLoaderResourcesGenerator generator = new ExtensionsTestLoaderResourcesGenerator(this.getResourceFactories(), generatedResourcesDirectory);
        generator.generateFor(extensionModel);
        return generator.dumpAll();
    }

    public List<GeneratedResource> generateDslResources(File generatedResourcesDirectory) {
        return this.generateDslResources(generatedResourcesDirectory, null);
    }

    public List<GeneratedResource> generateDslResources(File generatedResourcesDirectory, ExtensionModel forExtensionModel) {
        DslResolvingContext context = this.extensionManager.getExtensions().stream().anyMatch(e -> !e.getImportedTypes().isEmpty()) ? name -> this.extensionManager.getExtension(name).map(e -> e) : name -> Optional.empty();
        ExtensionsTestDslResourcesGenerator dslResourceGenerator = new ExtensionsTestDslResourcesGenerator(this.getDslResourceFactories(), generatedResourcesDirectory, context);
        this.extensionManager.getExtensions().stream().filter(runtimeExtensionModel -> forExtensionModel != null ? runtimeExtensionModel.equals(forExtensionModel) : true).forEach(dslResourceGenerator::generateFor);
        return dslResourceGenerator.dumpAll();
    }

    private List<GeneratedResourceFactory> getResourceFactories() {
        return ImmutableList.copyOf((Collection)this.serviceRegistry.lookupProviders(GeneratedResourceFactory.class, Thread.currentThread().getContextClassLoader()));
    }

    private List<DslResourceFactory> getDslResourceFactories() {
        return ImmutableList.copyOf((Collection)this.serviceRegistry.lookupProviders(DslResourceFactory.class, Thread.currentThread().getContextClassLoader()));
    }

    private void loadExtensionsFromDescribers(ExtensionManagerAdapter extensionManager, Describer[] describers) {
        for (Describer describer : describers) {
            extensionManager.registerExtension(this.loadExtensionModel(describer));
        }
    }

    private ExtensionModel loadExtensionModel(Describer describer) {
        DefaultDescribingContext context = new DefaultDescribingContext(this.getClass().getClassLoader());
        return this.extensionFactory.createFrom(describer.describe((DescribingContext)context), (DescribingContext)context);
    }

    private File createManifestFileIfNecessary(File targetDirectory) {
        return this.createManifestFileIfNecessary(targetDirectory, MuleManifest.getManifest());
    }

    private File createManifestFileIfNecessary(File targetDirectory, Manifest sourceManifest) {
        try {
            File manifestFile = new File(targetDirectory.getPath(), "MANIFEST.MF");
            if (!manifestFile.exists()) {
                Manifest manifest = new Manifest(sourceManifest);
                try (FileOutputStream fileOutputStream = new FileOutputStream(manifestFile);){
                    manifest.write(fileOutputStream);
                }
            }
            return manifestFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating discoverer", e);
        }
    }
}

