/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.mule.test.runner.api.DependencyResolver;
import org.mule.test.runner.api.WorkspaceLocationResolver;
import org.mule.test.runner.classification.DefaultWorkspaceReader;
import org.mule.test.runner.classification.LoggerRepositoryListener;

public class RepositorySystemFactory {
    private static final String DEFAULT_REPOSITORY_TYPE = "default";

    public static DependencyResolver newOfflineDependencyResolver(List<URL> classPath, WorkspaceLocationResolver workspaceLocationResolver, File mavenLocalRepositoryLocation) {
        DefaultRepositorySystemSession session = RepositorySystemFactory.newDefaultRepositorySystemSession();
        session.setOffline(true);
        session.setIgnoreArtifactDescriptorRepositories(true);
        RepositorySystem system = RepositorySystemFactory.newRepositorySystem(classPath, workspaceLocationResolver, mavenLocalRepositoryLocation, session);
        return new DependencyResolver(system, (RepositorySystemSession)session, Collections.emptyList());
    }

    public static DependencyResolver newOnlineDependencyResolver(List<URL> classPath, WorkspaceLocationResolver workspaceLocationResolver, File mavenLocalRepositoryLocation, List<String> remoteRepositories) {
        DefaultRepositorySystemSession session = RepositorySystemFactory.newDefaultRepositorySystemSession();
        session.setIgnoreArtifactDescriptorRepositories(true);
        RepositorySystem system = RepositorySystemFactory.newRepositorySystem(classPath, workspaceLocationResolver, mavenLocalRepositoryLocation, session);
        return new DependencyResolver(system, (RepositorySystemSession)session, RepositorySystemFactory.collectRemoteRepositories(remoteRepositories));
    }

    private static List<RemoteRepository> collectRemoteRepositories(List<String> remoteRepositories) {
        List<RemoteRepository> collectedRemoteRepositories = remoteRepositories.stream().filter(remoteRepository -> !remoteRepository.trim().equals("")).map(remoteRepository -> new RemoteRepository.Builder(remoteRepository, DEFAULT_REPOSITORY_TYPE, remoteRepository.trim()).build()).collect(Collectors.toList());
        return collectedRemoteRepositories;
    }

    private static DefaultRepositorySystemSession newDefaultRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setUpdatePolicy("never");
        session.setChecksumPolicy("ignore");
        return session;
    }

    private static RepositorySystem newRepositorySystem(List<URL> classPath, WorkspaceLocationResolver workspaceLocationResolver, File mavenLocalRepositoryLocation, DefaultRepositorySystemSession session) {
        RepositorySystem system = RepositorySystemFactory.newRepositorySystem();
        LocalRepository localRepo = new LocalRepository(mavenLocalRepositoryLocation, "simple");
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setWorkspaceReader((WorkspaceReader)new DefaultWorkspaceReader(classPath, workspaceLocationResolver));
        session.setRepositoryListener((RepositoryListener)new LoggerRepositoryListener());
        return system;
    }

    private static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                exception.printStackTrace();
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

