/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.ContainerClassLoaderFilterFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.deployment.model.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.ClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.util.FileJarExplorer;
import org.mule.runtime.module.artifact.util.JarInfo;
import org.mule.test.runner.api.ArtifactClassLoaderHolder;
import org.mule.test.runner.api.ArtifactUrlClassification;
import org.mule.test.runner.api.ArtifactsUrlClassification;
import org.mule.test.runner.api.PluginUrlClassification;
import org.mule.test.runner.classloader.PluginLookPolicyFactory;
import org.mule.test.runner.classloader.TestArtifactClassLoaderFilter;
import org.mule.test.runner.classloader.TestContainerClassLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedClassLoaderFactory {
    private static final String APP_NAME = "app";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClassLoaderFilterFactory classLoaderFilterFactory = new ArtifactClassLoaderFilterFactory();
    private PluginLookPolicyFactory pluginLookupPolicyGenerator = new PluginLookPolicyFactory();

    public ArtifactClassLoaderHolder createArtifactClassLoader(List<String> extraBootPackages, ArtifactsUrlClassification artifactsUrlClassification) {
        RegionClassLoader regionClassLoader;
        List<ArtifactClassLoader> serviceArtifactClassLoaders;
        ClassLoaderLookupPolicy childClassLoaderLookupPolicy;
        ArtifactClassLoader containerClassLoader;
        JarInfo testJarInfo = this.getTestJarInfo(artifactsUrlClassification);
        HashMap appExportedLookupStrategies = new HashMap();
        testJarInfo.getPackages().stream().forEach(p -> appExportedLookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST));
        ArrayList<FilteringArtifactClassLoader> filteredPluginsArtifactClassLoaders = new ArrayList<FilteringArtifactClassLoader>();
        ArrayList<ArtifactClassLoader> pluginsArtifactClassLoaders = new ArrayList<ArtifactClassLoader>();
        ArrayList<ArtifactClassLoaderFilter> pluginArtifactClassLoaderFilters = new ArrayList<ArtifactClassLoaderFilter>();
        DefaultModuleRepository moduleRepository = new DefaultModuleRepository((ModuleDiscoverer)new ContainerModuleDiscoverer(ContainerClassLoaderFactory.class.getClassLoader()));
        try (TestContainerClassLoaderFactory testContainerClassLoaderFactory = new TestContainerClassLoaderFactory(extraBootPackages, artifactsUrlClassification.getContainerUrls().toArray(new URL[0]), (ModuleRepository)moduleRepository);){
            containerClassLoader = this.createContainerArtifactClassLoader(testContainerClassLoaderFactory, artifactsUrlClassification);
            childClassLoaderLookupPolicy = testContainerClassLoaderFactory.getContainerClassLoaderLookupPolicy(containerClassLoader.getClassLoader());
            serviceArtifactClassLoaders = this.createServiceClassLoaders(containerClassLoader.getClassLoader(), childClassLoaderLookupPolicy, artifactsUrlClassification);
            regionClassLoader = new RegionClassLoader("Region", new ArtifactDescriptor("Region"), containerClassLoader.getClassLoader(), childClassLoaderLookupPolicy);
            if (!artifactsUrlClassification.getPluginUrlClassifications().isEmpty()) {
                for (PluginUrlClassification pluginUrlClassification : artifactsUrlClassification.getPluginUrlClassifications()) {
                    this.logClassLoaderUrls("PLUGIN (" + pluginUrlClassification.getName() + ")", pluginUrlClassification.getUrls());
                    String artifactId = AbstractArtifactClassLoaderBuilder.getArtifactPluginId((String)regionClassLoader.getArtifactId(), (String)pluginUrlClassification.getName());
                    ClassLoaderLookupPolicy pluginLookupPolicy = this.extendLookupPolicyForPrivilegedAccess(childClassLoaderLookupPolicy, moduleRepository, testContainerClassLoaderFactory, pluginUrlClassification);
                    pluginLookupPolicy = pluginLookupPolicy.extend(appExportedLookupStrategies);
                    MuleArtifactClassLoader pluginCL = new MuleArtifactClassLoader(artifactId, new ArtifactDescriptor(pluginUrlClassification.getName()), pluginUrlClassification.getUrls().toArray(new URL[0]), (ClassLoader)regionClassLoader, this.pluginLookupPolicyGenerator.createLookupPolicy(pluginUrlClassification, artifactsUrlClassification.getPluginUrlClassifications(), pluginLookupPolicy));
                    pluginsArtifactClassLoaders.add((ArtifactClassLoader)pluginCL);
                    ArtifactClassLoaderFilter filter = this.createArtifactClassLoaderFilter(pluginUrlClassification, testJarInfo.getPackages(), childClassLoaderLookupPolicy);
                    pluginArtifactClassLoaderFilters.add(filter);
                    filteredPluginsArtifactClassLoaders.add(new FilteringArtifactClassLoader((ArtifactClassLoader)pluginCL, (ClassLoaderFilter)filter, Collections.emptyList()));
                }
            }
        }
        HashMap pluginsLookupStrategies = new HashMap();
        for (int i = 0; i < filteredPluginsArtifactClassLoaders.size(); ++i) {
            ArtifactClassLoaderFilter classLoaderFilter = (ArtifactClassLoaderFilter)pluginArtifactClassLoaderFilters.get(i);
            classLoaderFilter.getExportedClassPackages().forEach(p -> pluginsLookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST));
        }
        ClassLoaderLookupPolicy appLookupPolicy = childClassLoaderLookupPolicy.extend(pluginsLookupStrategies);
        ArtifactClassLoader appClassLoader = this.createApplicationArtifactClassLoader((ClassLoader)regionClassLoader, appLookupPolicy, artifactsUrlClassification, pluginsArtifactClassLoaders);
        regionClassLoader.addClassLoader(appClassLoader, (ArtifactClassLoaderFilter)new DefaultArtifactClassLoaderFilter(testJarInfo.getPackages(), testJarInfo.getResources()));
        for (int i = 0; i < filteredPluginsArtifactClassLoaders.size(); ++i) {
            ArtifactClassLoaderFilter classLoaderFilter = (ArtifactClassLoaderFilter)pluginArtifactClassLoaderFilters.get(i);
            regionClassLoader.addClassLoader((ArtifactClassLoader)filteredPluginsArtifactClassLoaders.get(i), classLoaderFilter);
        }
        return new ArtifactClassLoaderHolder(containerClassLoader, serviceArtifactClassLoaders, pluginsArtifactClassLoaders, appClassLoader);
    }

    private ClassLoaderLookupPolicy extendLookupPolicyForPrivilegedAccess(ClassLoaderLookupPolicy childClassLoaderLookupPolicy, DefaultModuleRepository moduleRepository, TestContainerClassLoaderFactory testContainerClassLoaderFactory, PluginUrlClassification pluginUrlClassification) {
        ContainerOnlyLookupStrategy containerOnlyLookupStrategy = new ContainerOnlyLookupStrategy(testContainerClassLoaderFactory.getContainerClassLoader().getClassLoader());
        HashMap<String, ContainerOnlyLookupStrategy> privilegedLookupStrategies = new HashMap<String, ContainerOnlyLookupStrategy>();
        for (MuleModule module : moduleRepository.getModules()) {
            if (!this.hasPrivilegedApiAccess(pluginUrlClassification, module)) continue;
            for (String packageName : module.getPrivilegedExportedPackages()) {
                privilegedLookupStrategies.put(packageName, containerOnlyLookupStrategy);
            }
        }
        if (privilegedLookupStrategies.isEmpty()) {
            return childClassLoaderLookupPolicy;
        }
        return childClassLoaderLookupPolicy.extend(privilegedLookupStrategies);
    }

    private boolean hasPrivilegedApiAccess(PluginUrlClassification pluginUrlClassification, MuleModule module) {
        return module.getPrivilegedArtifacts().stream().filter(artifact -> pluginUrlClassification.getName().contains(":" + artifact + ":")).findFirst().isPresent();
    }

    protected List<ArtifactClassLoader> createServiceClassLoaders(ClassLoader parent, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ArtifactsUrlClassification artifactsUrlClassification) {
        ArrayList servicesArtifactClassLoaders = Lists.newArrayList();
        for (ArtifactUrlClassification serviceUrlClassification : artifactsUrlClassification.getServiceUrlClassifications()) {
            this.logClassLoaderUrls("SERVICE (" + serviceUrlClassification.getArtifactId() + ")", serviceUrlClassification.getUrls());
            MuleArtifactClassLoader artifactClassLoader = new MuleArtifactClassLoader(serviceUrlClassification.getName(), new ArtifactDescriptor(serviceUrlClassification.getName()), serviceUrlClassification.getUrls().toArray(new URL[0]), parent, childClassLoaderLookupPolicy);
            servicesArtifactClassLoaders.add(artifactClassLoader);
        }
        return servicesArtifactClassLoaders;
    }

    private JarInfo getTestJarInfo(ArtifactsUrlClassification artifactsUrlClassification) {
        URL testCodeUrl = artifactsUrlClassification.getApplicationUrls().get(0);
        if (!FileUtils.toFile((URL)testCodeUrl).getPath().contains("test-classes") && artifactsUrlClassification.getApplicationUrls().size() > 1) {
            testCodeUrl = artifactsUrlClassification.getApplicationUrls().get(1);
        }
        Set<String> productionPackages = this.getProductionCodePackages(testCodeUrl);
        JarInfo testJarInfo = this.getTestCodePackages(artifactsUrlClassification, testCodeUrl);
        Set<String> testPackages = this.sanitizeTestExportedPackages(productionPackages, testJarInfo.getPackages());
        return new JarInfo(testPackages, testJarInfo.getResources());
    }

    private Set<String> sanitizeTestExportedPackages(Set<String> productionPackages, Set<String> testPackages) {
        HashSet<String> sanitizedTestPackages = new HashSet<String>(testPackages);
        this.removePackagesFromTestClassLoader(sanitizedTestPackages, ContainerClassLoaderFactory.SYSTEM_PACKAGES);
        this.removePackagesFromTestClassLoader(sanitizedTestPackages, productionPackages);
        return sanitizedTestPackages;
    }

    private JarInfo getTestCodePackages(ArtifactsUrlClassification artifactsUrlClassification, URL testCodeUrl) {
        ArrayList libraries = Lists.newArrayList((Object[])new URL[]{testCodeUrl});
        libraries.addAll(artifactsUrlClassification.getPluginSharedLibUrls());
        HashSet packages = new HashSet();
        HashSet resources = new HashSet();
        FileJarExplorer jarExplorer = new FileJarExplorer();
        for (URL library : libraries) {
            try {
                JarInfo jarInfo = jarExplorer.explore(library.toURI());
                packages.addAll(jarInfo.getPackages());
                resources.addAll(jarInfo.getResources());
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return new JarInfo(packages, resources);
    }

    private Set<String> getProductionCodePackages(URL testCodeUrl) {
        int index = testCodeUrl.toString().lastIndexOf("test-classes");
        try {
            URI productionCodeUri = new URL(testCodeUrl.toString().substring(0, index) + "classes").toURI();
            if (new File(productionCodeUri).exists()) {
                FileJarExplorer jarExplorer = new FileJarExplorer();
                return jarExplorer.explore(productionCodeUri).getPackages();
            }
            return Collections.emptySet();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void removePackagesFromTestClassLoader(Set<String> packages, Collection<String> systemPackages) {
        HashSet packagesToRemove = new HashSet();
        systemPackages.stream().forEach(systemPackage -> packages.stream().filter(p -> p.startsWith((String)systemPackage)).forEach(p -> packagesToRemove.add(p)));
        packages.removeAll(packagesToRemove);
    }

    protected ArtifactClassLoader createContainerArtifactClassLoader(TestContainerClassLoaderFactory testContainerClassLoaderFactory, ArtifactsUrlClassification artifactsUrlClassification) {
        MuleArtifactClassLoader launcherArtifact = this.createLauncherArtifactClassLoader();
        List muleModules = Collections.emptyList();
        ClassLoaderFilter filteredClassLoaderLauncher = new ContainerClassLoaderFilterFactory().create(testContainerClassLoaderFactory.getBootPackages(), muleModules);
        this.logClassLoaderUrls("CONTAINER", artifactsUrlClassification.getContainerUrls());
        ArtifactClassLoader containerClassLoader = testContainerClassLoaderFactory.createContainerClassLoader((ClassLoader)new FilteringArtifactClassLoader((ArtifactClassLoader)launcherArtifact, filteredClassLoaderLauncher, Collections.emptyList()));
        return containerClassLoader;
    }

    protected MuleArtifactClassLoader createLauncherArtifactClassLoader() {
        ClassLoader launcherClassLoader = IsolatedClassLoaderFactory.class.getClassLoader();
        return new MuleArtifactClassLoader("launcher", new ArtifactDescriptor("launcher"), new URL[0], launcherClassLoader, (ClassLoaderLookupPolicy)new MuleClassLoaderLookupPolicy(Collections.emptyMap(), Collections.emptySet())){

            public URL findResource(String name) {
                URL url = super.findResource(name);
                if (url == null && this.getParent() != null) {
                    url = this.getParent().getResource(name);
                }
                return url;
            }
        };
    }

    private ArtifactClassLoaderFilter createArtifactClassLoaderFilter(PluginUrlClassification pluginUrlClassification, Set<String> parentExportedPackages, ClassLoaderLookupPolicy childClassLoaderLookupPolicy) {
        Set<String> sanitizedExportedPackages = this.sanitizePluginExportedPackages(pluginUrlClassification, parentExportedPackages, childClassLoaderLookupPolicy);
        String exportedPackages = sanitizedExportedPackages.stream().collect(Collectors.joining(", "));
        String exportedResources = pluginUrlClassification.getExportedResources().stream().collect(Collectors.joining(", "));
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.classLoaderFilterFactory.create(exportedPackages, exportedResources);
        if (!pluginUrlClassification.getExportClasses().isEmpty()) {
            artifactClassLoaderFilter = new TestArtifactClassLoaderFilter(artifactClassLoaderFilter, pluginUrlClassification.getExportClasses());
        }
        return artifactClassLoaderFilter;
    }

    private Set<String> sanitizePluginExportedPackages(PluginUrlClassification pluginUrlClassification, Set<String> parentExportedPackages, ClassLoaderLookupPolicy childClassLoaderLookupPolicy) {
        Set appProvidedPackages;
        HashSet<String> exportedPackages = new HashSet<String>(pluginUrlClassification.getExportedPackages());
        Set containerProvidedPackages = exportedPackages.stream().filter(p -> {
            LookupStrategy lookupStrategy = childClassLoaderLookupPolicy.getPackageLookupStrategy(p);
            return !(lookupStrategy instanceof ChildFirstLookupStrategy);
        }).collect(Collectors.toSet());
        if (!containerProvidedPackages.isEmpty()) {
            exportedPackages.removeAll(containerProvidedPackages);
            this.logger.warn("Exported packages from plugin '" + pluginUrlClassification.getName() + "' are provided by parent class loader: " + containerProvidedPackages);
        }
        if (!(appProvidedPackages = parentExportedPackages.stream().filter(p -> exportedPackages.contains(p)).collect(Collectors.toSet())).isEmpty()) {
            exportedPackages.removeAll(appProvidedPackages);
            this.logger.warn("Exported packages from plugin '" + pluginUrlClassification.getName() + "' are provided by the artifact owner: " + appProvidedPackages);
        }
        return exportedPackages;
    }

    protected ArtifactClassLoader createApplicationArtifactClassLoader(ClassLoader parent, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ArtifactsUrlClassification artifactsUrlClassification, List<ArtifactClassLoader> pluginsArtifactClassLoaders) {
        this.logClassLoaderUrls("APP", artifactsUrlClassification.getApplicationUrls());
        return new MuleApplicationClassLoader(APP_NAME, new ArtifactDescriptor(APP_NAME), parent, new DefaultNativeLibraryFinderFactory().create(APP_NAME, artifactsUrlClassification.getApplicationUrls().toArray(new URL[pluginsArtifactClassLoaders.size()])), artifactsUrlClassification.getApplicationUrls(), childClassLoaderLookupPolicy, pluginsArtifactClassLoaders);
    }

    protected void logClassLoaderUrls(String classLoaderName, List<URL> urls) {
        StringBuilder builder = new StringBuilder(classLoaderName).append(" classloader urls: [");
        urls.stream().forEach(e -> builder.append("\n").append(" ").append(e));
        builder.append("\n]");
        this.logClassLoadingTrace(builder.toString());
    }

    private void logClassLoadingTrace(String message) {
        if (this.isVerboseClassLoading().booleanValue()) {
            this.logger.info(message);
        } else {
            this.logger.debug(message);
        }
    }

    private Boolean isVerboseClassLoading() {
        return Boolean.valueOf(System.getProperty("mule.classloading.verbose"));
    }
}

