/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.functional.Either;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Threads(value=3)
public class EitherBenchmark
extends AbstractBenchmark {
    @Benchmark
    public Either<String, String> left() {
        return Either.left((Object)"Hello");
    }

    @Benchmark
    public Either<String, String> right() {
        return Either.right((Object)"World");
    }

    @Benchmark
    public Object applyLeft() {
        AtomicReference ref = new AtomicReference();
        this.left().applyLeft(ref::set);
        return ref.get();
    }

    @Benchmark
    public Object applyRight() {
        AtomicReference ref = new AtomicReference();
        this.right().applyRight(ref::set);
        return ref.get();
    }

    @Benchmark
    public Object apply() {
        AtomicReference ref = new AtomicReference();
        this.left().apply(ref::set, ref::set);
        return ref.get();
    }

    @Benchmark
    public Object mapLeft() {
        return this.left().mapLeft(l -> l + "!!");
    }

    @Benchmark
    public Object mapRight() {
        return this.right().mapLeft(r -> r + "!!");
    }

    @Benchmark
    public Object value() {
        return this.right().getValue();
    }
}

