/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime;

import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class I18nMessageFactoryBenchmark {
    public static final String TEST_MESSAGE_PARAMETER = "Testing!";
    @Param(value={"true", "false"})
    public boolean customControl;

    @Setup
    public void setUp() {
        TestI18nMessages.customControl = this.customControl;
        TestI18nMessages.testMessage(TEST_MESSAGE_PARAMETER);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public I18nMessage createI18nMessage() {
        return TestI18nMessages.testMessage(TEST_MESSAGE_PARAMETER);
    }

    public static class TestI18nMessages
    extends I18nMessageFactory {
        private static final TestI18nMessages factory = new TestI18nMessages();
        private static final ResourceBundle.Control defaultControl = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
        public static boolean customControl = true;
        private static final String BUNDLE_PATH = TestI18nMessages.getBundlePath((String)"test");

        public static I18nMessage testMessage(String arg) {
            return factory.createMessage(BUNDLE_PATH, 1, arg);
        }

        protected ResourceBundle.Control getReloadControl() {
            if (customControl) {
                return super.getReloadControl();
            }
            return defaultControl;
        }
    }
}

