/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.collection.SmallMap;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.TearDown;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class SmallMapBenchmark
extends AbstractBenchmark {
    private static final String[] KEYS = new String[]{"one", "two", "three", "four", "five", "six", "seven"};
    private static final String[] VALUES = new String[]{"uno", "dos", "tres", "cuatro", "cinco", "seis", "siete"};

    @TearDown
    public void teardown() throws MuleException {
    }

    @Benchmark
    public Object hashMapOf3() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.populate(map, 3);
        map.get("one");
        map.get("three");
        return map;
    }

    @Benchmark
    public Object smallMapOf3() {
        SmallMap map = new SmallMap();
        this.populate((Map<String, String>)map, 3);
        map.get("one");
        map.get("three");
        return map;
    }

    @Benchmark
    public Object hashMapOf6() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.populate(map, 6);
        map.get("one");
        map.get("three");
        map.get("six");
        return map;
    }

    @Benchmark
    public Object smallMapOf6() {
        SmallMap map = new SmallMap();
        this.populate((Map<String, String>)map, 6);
        map.get("one");
        map.get("three");
        map.get("six");
        return map;
    }

    private void populate(Map<String, String> map, int size) {
        for (int i = 0; i < size; ++i) {
            map.put(KEYS[i], VALUES[i]);
        }
    }
}

