/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.Serializable;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Setup;

public class MessageBenchmark
extends AbstractBenchmark {
    private Message message;
    private Message messageWith20Properties;
    private Message messageWith100Properties;

    @Setup
    public void setup() throws Exception {
        this.message = this.createMuleMessage();
        this.messageWith20Properties = this.createMuleMessageWithProperties(20);
        this.messageWith100Properties = this.createMuleMessageWithProperties(100);
    }

    @Benchmark
    public Message createMessage() {
        return Message.of((Object)PAYLOAD);
    }

    @Benchmark
    public Message createMessageWithDataType() {
        return Message.builder().payload((Object)PAYLOAD).mediaType(MediaType.TEXT).build();
    }

    @Benchmark
    public Message copyMessage() {
        return Message.builder((Message)this.message).build();
    }

    @Benchmark
    public Message copyMessageWith20Properties() {
        return Message.builder((Message)this.messageWith20Properties).build();
    }

    @Benchmark
    public Message copyMessageWith100Properties() {
        return Message.builder((Message)this.messageWith100Properties).build();
    }

    @Benchmark
    public Message mutateMessagePayload() {
        return Message.builder((Message)this.message).payload((Object)"value").build();
    }

    @Benchmark
    public Message mutateMessagePayloadWithDataType() {
        return Message.builder((Message)this.message).payload((Object)"value").mediaType(MediaType.TEXT).build();
    }

    @Benchmark
    public Message addMessageProperty() {
        return InternalMessage.builder((Message)this.message).addOutboundProperty("key", (Serializable)((Object)"value")).build();
    }

    @Benchmark
    public Message addMessagePropertyMessageWith20Properties() {
        return InternalMessage.builder((Message)this.messageWith20Properties).addOutboundProperty("key", (Serializable)((Object)"value")).build();
    }

    @Benchmark
    public Message addMessagePropertyMessageWith100Properties() {
        return InternalMessage.builder((Message)this.messageWith100Properties).addOutboundProperty("key", (Serializable)((Object)"value")).build();
    }

    @Benchmark
    public Message addMessagePropertyWithDataType() {
        return InternalMessage.builder((Message)this.message).addOutboundProperty("key", (Serializable)((Object)"value"), DataType.STRING).build();
    }

    @Benchmark
    public Message addRemoveMessageProperty() {
        InternalMessage temp = InternalMessage.builder((Message)this.message).addOutboundProperty("key", (Serializable)((Object)"value")).build();
        return InternalMessage.builder((Message)temp).removeOutboundProperty("key").build();
    }

    @Benchmark
    public Message addRemoveMessagePropertyMessageWith20Properties() {
        InternalMessage temp = InternalMessage.builder((Message)this.messageWith20Properties).addOutboundProperty("key", (Serializable)((Object)"value")).build();
        return InternalMessage.builder((Message)temp).removeOutboundProperty("key").build();
    }

    @Benchmark
    public Message addRemoveMessagePropertyMessageWith100Properties() {
        InternalMessage temp = InternalMessage.builder((Message)this.messageWith100Properties).addOutboundProperty("key", (Serializable)((Object)"value")).build();
        return InternalMessage.builder((Message)temp).removeOutboundProperty("key").build();
    }

    @Benchmark
    public Message addRemoveMessagePropertyWithDataType() {
        InternalMessage temp = InternalMessage.builder((Message)this.message).addOutboundProperty("key", (Serializable)((Object)"value"), DataType.STRING).build();
        return InternalMessage.builder((Message)temp).removeOutboundProperty("key").build();
    }

    @Benchmark
    public Message copyWith20PropertiesWrite1Outbound() {
        InternalMessage.Builder builder = InternalMessage.builder((Message)this.messageWith20Properties);
        for (int j = 1; j <= 10; ++j) {
            builder.addInboundProperty("newKey" + j, (Serializable)((Object)"val"));
        }
        return builder.build();
    }

    @Benchmark
    public Message copyWith20PopertiesWrite100Outbound() {
        InternalMessage.Builder builder = InternalMessage.builder((Message)this.messageWith20Properties);
        for (int j = 1; j <= 100; ++j) {
            builder.addInboundProperty("newKey" + j, (Serializable)((Object)"val"));
        }
        return builder.build();
    }

    @Benchmark
    public Message copyWith100PropertiesWrite1Outbound() {
        InternalMessage.Builder builder = InternalMessage.builder((Message)this.messageWith100Properties);
        for (int j = 1; j <= 10; ++j) {
            builder.addInboundProperty("newKey" + j, (Serializable)((Object)"val"));
        }
        return builder.build();
    }

    @Benchmark
    public Message copyWith100PropertiesWrite50Outbound() {
        InternalMessage.Builder builder = InternalMessage.builder((Message)this.messageWith100Properties);
        for (int j = 1; j <= 50; ++j) {
            builder.addInboundProperty("newKey" + j, (Serializable)((Object)"val"));
        }
        return builder.build();
    }

    private Message createMuleMessage() {
        return Message.of((Object)PAYLOAD);
    }

    private Message createMuleMessageWithProperties(int numProperties) {
        int i;
        InternalMessage.Builder builder = InternalMessage.builder().payload((Object)PAYLOAD);
        for (i = 1; i <= numProperties; ++i) {
            builder.addInboundProperty("InBoUnDpRoPeRtYkEy" + i, (Serializable)((Object)"val"));
        }
        for (i = 1; i <= numProperties; ++i) {
            builder.addOutboundProperty("OuTBoUnDpRoPeRtYkEy" + i, (Serializable)((Object)"val"));
        }
        return builder.build();
    }
}

