/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.concurrent.TimeUnit;
import org.mule.BenchmarkUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class MuleMessageBenchmark {
    public static final String TEST_PAYLOAD = "test";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private MuleContext muleContext;
    private MuleMessage message;
    private MuleMessage messageWith20Properties;
    private MuleMessage messageWith100Properties;

    @Setup
    public void setup() throws Exception {
        int i;
        this.muleContext = BenchmarkUtils.createMuleContext();
        this.message = new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext);
        this.messageWith20Properties = new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext);
        for (i = 0; i < 20; ++i) {
            this.messageWith20Properties.setOutboundProperty("key1", (Object)VALUE);
        }
        this.messageWith100Properties = new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext);
        for (i = 0; i < 100; ++i) {
            this.messageWith20Properties.setOutboundProperty("key1", (Object)VALUE);
        }
    }

    @TearDown
    public void teardown() {
        this.muleContext.dispose();
    }

    @Benchmark
    public MuleMessage createMessage() throws MuleException {
        return new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext);
    }

    @Benchmark
    public MuleMessage createMessageWithDataType() throws MuleException {
        return new DefaultMuleMessage((Object)TEST_PAYLOAD, null, null, null, this.muleContext, DataType.STRING_DATA_TYPE);
    }

    @Benchmark
    public MuleMessage copyMessage() throws MuleException {
        return new DefaultMuleMessage(this.message);
    }

    @Benchmark
    public MuleMessage copyMessageWith20VariablesProperties() throws MuleException {
        return new DefaultMuleMessage(this.messageWith20Properties);
    }

    @Benchmark
    public MuleMessage copyMessageWith100VariablesProperties() throws MuleException {
        return new DefaultMuleMessage(this.messageWith100Properties);
    }

    @Benchmark
    public MuleMessage mutateMessagePayload() throws MuleException {
        this.message.setPayload((Object)VALUE);
        return this.message;
    }

    @Benchmark
    public MuleMessage mutateMessagePayloadWithDataType() throws MuleException {
        this.message.setPayload((Object)VALUE, DataType.STRING_DATA_TYPE);
        return this.message;
    }

    @Benchmark
    public MuleMessage addMessageProperty() throws MuleException {
        this.message.setOutboundProperty(KEY, (Object)VALUE);
        return this.message;
    }

    @Benchmark
    public MuleMessage addMessagePropertyMessageWith20Properties() throws MuleException {
        this.messageWith20Properties.setOutboundProperty(KEY, (Object)VALUE);
        return this.message;
    }

    @Benchmark
    public MuleMessage addMessagePropertyMessageWith100Properties() throws MuleException {
        this.messageWith100Properties.setOutboundProperty(KEY, (Object)VALUE);
        return this.message;
    }

    @Benchmark
    public MuleMessage addMessagePropertyWithDataType() throws MuleException {
        this.message.setOutboundProperty(KEY, (Object)VALUE, DataType.STRING_DATA_TYPE);
        return this.message;
    }

    @Benchmark
    public MuleMessage addRemoveMessageProperty() throws MuleException {
        this.message.setOutboundProperty(KEY, (Object)VALUE);
        this.message.removeProperty(KEY, PropertyScope.OUTBOUND);
        return this.message;
    }

    @Benchmark
    public MuleMessage addRemoveMessagePropertyMessageWith20Properties() throws MuleException {
        this.messageWith20Properties.setOutboundProperty(KEY, (Object)VALUE);
        this.messageWith20Properties.removeProperty(KEY, PropertyScope.OUTBOUND);
        return this.message;
    }

    @Benchmark
    public MuleMessage addRemoveMessagePropertyMessageWith100Properties() throws MuleException {
        this.messageWith100Properties.setOutboundProperty(KEY, (Object)VALUE);
        this.messageWith100Properties.removeProperty(KEY, PropertyScope.OUTBOUND);
        return this.message;
    }

    @Benchmark
    public MuleMessage addRemoveMessagePropertyWithDataType() throws MuleException {
        this.message.setOutboundProperty(KEY, (Object)VALUE, DataType.STRING_DATA_TYPE);
        this.message.removeProperty(KEY, PropertyScope.OUTBOUND);
        return this.message;
    }
}

