/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.concurrent.TimeUnit;
import org.mule.BenchmarkUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class MuleEventBenchmark {
    public static final String TEST_PAYLOAD = "test";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private MuleContext muleContext;
    private Flow flow;
    private MuleEvent event;
    private MuleEvent eventWith20VariablesProperties;
    private MuleEvent eventWith100VariablesProperties;

    @Setup
    public void setup() throws Exception {
        int i;
        this.muleContext = BenchmarkUtils.createMuleContext();
        this.muleContext.start();
        this.flow = new Flow("flow", this.muleContext);
        this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)this.flow);
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow);
        this.eventWith20VariablesProperties = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow);
        for (i = 0; i < 20; ++i) {
            this.eventWith20VariablesProperties.setFlowVariable(KEY + i, (Object)VALUE);
            this.eventWith20VariablesProperties.getMessage().setOutboundProperty("key1", (Object)VALUE);
        }
        this.eventWith100VariablesProperties = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow);
        for (i = 0; i < 100; ++i) {
            this.eventWith100VariablesProperties.setFlowVariable(KEY + i, (Object)VALUE);
            this.eventWith100VariablesProperties.getMessage().setOutboundProperty("key1", (Object)VALUE);
        }
    }

    @TearDown
    public void teardown() {
        this.muleContext.dispose();
    }

    @Benchmark
    public String eventUUID() throws MuleException {
        return this.muleContext.getUniqueIdString();
    }

    @Benchmark
    public MuleEvent createEvent() throws MuleException {
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow);
    }

    @Benchmark
    public MuleEvent copyEvent() throws MuleException {
        return new DefaultMuleEvent(this.event.getMessage(), this.event);
    }

    @Benchmark
    public MuleEvent copyEventWith20VariablesProperties() throws MuleException {
        return new DefaultMuleEvent(this.eventWith20VariablesProperties.getMessage(), this.eventWith20VariablesProperties);
    }

    @Benchmark
    public MuleEvent copyEventWith100VariablesProperties() throws MuleException {
        return new DefaultMuleEvent(this.eventWith100VariablesProperties.getMessage(), this.eventWith100VariablesProperties);
    }

    @Benchmark
    public MuleEvent deepCopyEvent() throws MuleException {
        return DefaultMuleEvent.copy((MuleEvent)this.event);
    }

    @Benchmark
    public MuleEvent deepCopyEventWith20VariablesProperties() throws MuleException {
        return DefaultMuleEvent.copy((MuleEvent)this.eventWith20VariablesProperties);
    }

    @Benchmark
    public MuleEvent deepCopyEventWith100VariablesProperties() throws MuleException {
        return DefaultMuleEvent.copy((MuleEvent)this.eventWith100VariablesProperties);
    }

    @Benchmark
    public MuleEvent addEventVariable() throws MuleException {
        this.event.setFlowVariable(KEY, (Object)VALUE);
        return this.event;
    }

    @Benchmark
    public MuleEvent addEventVariableEventWith20VariablesProperties() throws MuleException {
        this.eventWith20VariablesProperties.setFlowVariable(KEY, (Object)VALUE);
        return this.event;
    }

    @Benchmark
    public MuleEvent addEventVariableEventWith100VariablesProperties() throws MuleException {
        this.eventWith100VariablesProperties.setFlowVariable(KEY, (Object)VALUE);
        return this.event;
    }
}

