/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public abstract class AbstractBenchmarkAssertionTestCase
extends AbstractMuleTestCase {
    private static final String SKIP_PERFORMANCE_TESTS_SYSTEM_PROPERTY = "skipPerformanceTests";

    protected void runAndAssertBenchmark(Class clazz, String testName, final double expectedResult, TimeUnit timeUnit) {
        this.runAndAssertBenchmark(clazz, testName, timeUnit, new AssertionCallback(){

            @Override
            public void assertResult(RunResult runResult) {
                Assert.assertThat((Object)runResult.getPrimaryResult().getScore(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(expectedResult)));
            }
        });
    }

    protected void runAndAssertBenchmark(Class clazz, String testName, TimeUnit timeUnit, AssertionCallback assertions) {
        try {
            if (System.getProperty(SKIP_PERFORMANCE_TESTS_SYSTEM_PROPERTY).equals(Boolean.TRUE.toString())) {
                Options opt = new OptionsBuilder().include(clazz.getSimpleName() + "." + testName).forks(0).timeUnit(timeUnit).warmupIterations(0).measurementIterations(1).build();
                new Runner(opt).runSingle();
            } else {
                Options opt = new OptionsBuilder().include(clazz.getSimpleName() + "." + testName).forks(1).timeUnit(timeUnit).warmupIterations(10).measurementIterations(10).build();
                assertions.assertResult(new Runner(opt).runSingle());
            }
        }
        catch (RunnerException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected static interface AssertionCallback {
        public void assertResult(RunResult var1);
    }
}

