/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.junit.ContiPerfRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.IOUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class MuleMessgeCopyPerformanceTestCase
extends AbstractMuleTestCase {
    @Rule
    public ContiPerfRule rule = new ContiPerfRule();
    @Mock
    private MuleContext muleContext;
    private String payload;
    private MuleMessage message;

    public int getTestTimeoutSecs() {
        return 120;
    }

    @Before
    public void before() throws IOException {
        this.payload = IOUtils.getResourceAsString((String)"test-data.json", ((Object)((Object)this)).getClass());
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copy() {
        MuleMessage original = this.createMuleMessage();
        for (int i = 0; i < 1000; ++i) {
            this.message = new DefaultMuleMessage(original);
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith20Poperties() {
        MuleMessage original = this.createMuleMessageWithProperties(10);
        for (int i = 0; i < 1000; ++i) {
            this.message = new DefaultMuleMessage(original);
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith100Poperties() {
        MuleMessage original = this.createMuleMessageWithProperties(50);
        for (int i = 0; i < 1000; ++i) {
            this.message = new DefaultMuleMessage(original);
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith20PopertiesWrite1Outbound() {
        MuleMessage original = this.createMuleMessageWithProperties(10);
        for (int i = 0; i < 1000; ++i) {
            this.message = new DefaultMuleMessage(original);
            this.message.setProperty("newKey", (Object)"val", PropertyScope.OUTBOUND);
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith20PopertiesWrite10Outbound() {
        MuleMessage original = this.createMuleMessageWithProperties(10);
        for (int i = 0; i < 1000; ++i) {
            this.message = new DefaultMuleMessage(original);
            for (int j = 1; j <= 10; ++j) {
                this.message.setProperty("newKey" + i, (Object)"val", PropertyScope.INBOUND);
            }
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith100PopertiesWrite1Outbound() {
        MuleMessage original = this.createMuleMessageWithProperties(50);
        for (int i = 0; i < 1000; ++i) {
            this.message = new DefaultMuleMessage(original);
            this.message.setProperty("newKey", (Object)"val", PropertyScope.OUTBOUND);
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith100PopertiesWrite50Outbound() {
        MuleMessage original = this.createMuleMessageWithProperties(50);
        for (int i = 0; i < 1000; ++i) {
            this.message = new DefaultMuleMessage(original);
            for (int j = 1; j <= 50; ++j) {
                this.message.setProperty("newKey" + i, (Object)"val", PropertyScope.INBOUND);
            }
        }
    }

    protected MuleMessage createMuleMessage() {
        return new DefaultMuleMessage((Object)this.payload, this.muleContext);
    }

    protected MuleMessage createMuleMessageWithProperties(int numProperties) {
        int i;
        MuleMessage message = this.createMuleMessage();
        for (i = 1; i <= numProperties; ++i) {
            message.setProperty("InBoUnDpRoPeRtYkEy" + i, (Object)"val", PropertyScope.INBOUND);
        }
        for (i = 1; i <= numProperties; ++i) {
            message.setProperty("OuTBoUnDpRoPeRtYkEy" + i, (Object)"val", PropertyScope.OUTBOUND);
        }
        return message;
    }
}

