/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.testmodels.fruit;

import java.util.HashMap;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.tck.testmodels.fruit.Fruit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterMelon
implements Fruit,
Startable,
Stoppable,
Disposable {
    private static final long serialVersionUID = -8860598811203869100L;
    private static final Logger logger = LoggerFactory.getLogger(WaterMelon.class);
    private boolean bitten = false;
    private Integer seeds = new Integer(100);
    private Double radius = new Double(4.34);
    private String brand;
    private String state = "void";

    public WaterMelon() {
    }

    public WaterMelon(HashMap props) throws MuleException {
        logger.info("Initialisaing Water melon with hashmap constructor");
        this.setBrand((String)props.get("namespace.brand"));
        this.setRadius((Double)props.get("another.namespace.radius"));
        this.setSeeds((Integer)props.get("seeds"));
        this.state = "initialised";
    }

    @Override
    public void bite() {
        this.bitten = true;
    }

    @Override
    public boolean isBitten() {
        return this.bitten;
    }

    public void myEventHandler(CoreEvent event, MuleContext muleContext) throws MuleException {
        logger.debug("Water Melon received an event in MyEventHandler! MuleEvent says: " + ((PrivilegedEvent)event).getMessageAsString(null));
        this.bite();
    }

    public String getBrand() {
        return this.brand;
    }

    public Integer getSeeds() {
        return this.seeds;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setBrand(String string) {
        this.brand = string;
    }

    public void setSeeds(Integer integer) {
        this.seeds = integer;
    }

    public void setRadius(Double double1) {
        this.radius = double1;
    }

    public String getState() {
        return this.state;
    }

    public void start() {
        this.state = "started";
    }

    public void stop() {
        this.state = "stopped";
    }

    public void dispose() {
        this.state = "disposed";
    }

    public boolean equals(Object obj) {
        if (obj instanceof WaterMelon) {
            WaterMelon melon = (WaterMelon)obj;
            return this.getBrand().equals(melon.getBrand()) && this.getRadius().equals(melon.getRadius()) && this.getSeeds().equals(melon.getSeeds()) && this.getState().equals(this.getState());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = this.bitten ? 1 : 0;
        result = 31 * result + this.seeds.hashCode();
        result = 31 * result + this.radius.hashCode();
        result = 31 * result + (this.brand != null ? this.brand.hashCode() : 0);
        result = 31 * result + this.state.hashCode();
        return result;
    }
}

