/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.service;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.test.integration.service.TestComponent;
import org.mule.util.StringMessageUtils;

public class TestReceiver {
    private static final Log logger = LogFactory.getLog(TestComponent.class);
    private AtomicInteger count = new AtomicInteger(0);

    public String receive(String message) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StringMessageUtils.getBoilerPlate((String)("Received: " + message + " Number: " + this.inc() + " in thread: " + Thread.currentThread().getName())));
            logger.debug((Object)("Message ID is: " + RequestContext.getEventContext().getMessage().getCorrelationId()));
        }
        return "Received: " + message;
    }

    public String receive(TextMessage message) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received: " + message.getText() + " Number: " + this.inc() + " in thread: " + Thread.currentThread().getName()));
            logger.debug((Object)("Message ID is: " + message.getJMSMessageID()));
        }
        return "Received: " + message.getText();
    }

    protected int inc() {
        return this.count.incrementAndGet();
    }
}

