/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.mule.test.infrastructure.deployment.TestArtifactsCatalog;

public class TestServicesSetup
extends ExternalResource {
    public static final String EXPRESSION_LANGUAGE_SERVICE_NAME = "expressionLanguageService";
    public static final String EXPRESSION_LANGUAGE_METADATA_SERVICE_NAME = "expressionLanguageMetadataService";
    public static final String SCHEDULER_SERVICE_NAME = "schedulerService";
    private final TemporaryFolder compilerWorkFolder;
    private File schedulerService;
    private File httpService;
    private File expressionLanguageService;
    private File expressionLanguageMetadataService;
    private boolean expressionLanguageMetadataServiceDisabled;

    public TestServicesSetup(TemporaryFolder compilerWorkFolder) {
        this.compilerWorkFolder = compilerWorkFolder;
    }

    public void overrideSchedulerService(Function<File, File> supplier) throws IOException {
        this.schedulerService = supplier.apply(this.compilerWorkFolder.newFolder("schedulerService_override"));
    }

    public void overrideExpressionLanguageService(Function<File, File> supplier) throws IOException {
        this.expressionLanguageService = supplier.apply(this.compilerWorkFolder.newFolder("expressionLanguageService_override"));
    }

    public void overrideExpressionLanguageMetadataService(Function<File, File> supplier) throws IOException {
        this.expressionLanguageMetadataService = supplier.apply(this.compilerWorkFolder.newFolder("expressionLanguageMetadataService_override"));
    }

    public void disableExpressionLanguageMetadataService() throws IOException {
        this.expressionLanguageMetadataServiceDisabled = true;
    }

    public File getSchedulerService() {
        return this.schedulerService;
    }

    public File getHttpService() {
        return this.httpService;
    }

    public File getExpressionLanguageService() {
        return this.expressionLanguageService;
    }

    public File getExpressionLanguageMetadataService() {
        return this.expressionLanguageMetadataService;
    }

    public void initNotOverriddenServices() throws IOException {
        if (this.schedulerService == null) {
            this.schedulerService = TestArtifactsCatalog.schedulerServiceJarFile;
        }
        if (this.httpService == null) {
            this.httpService = TestArtifactsCatalog.httpServiceJarFile;
        }
        if (this.expressionLanguageService == null) {
            this.expressionLanguageService = TestArtifactsCatalog.expressionLanguageServiceJarFile;
        }
        if (!this.expressionLanguageMetadataServiceDisabled && this.expressionLanguageMetadataService == null) {
            this.expressionLanguageMetadataService = TestArtifactsCatalog.expressionLanguageMetadataServiceJarFile;
        }
    }

    protected void after() {
        if (this.schedulerService != null && !this.schedulerService.equals(TestArtifactsCatalog.schedulerServiceJarFile)) {
            this.schedulerService.delete();
            this.schedulerService = null;
        }
        if (this.httpService != null && !this.httpService.equals(TestArtifactsCatalog.httpServiceJarFile)) {
            this.httpService.delete();
            this.httpService = null;
        }
        if (this.expressionLanguageService != null && !this.expressionLanguageService.equals(TestArtifactsCatalog.expressionLanguageServiceJarFile)) {
            this.expressionLanguageService.delete();
            this.expressionLanguageService = null;
        }
        if (!this.expressionLanguageMetadataServiceDisabled && this.expressionLanguageMetadataService != null && !this.expressionLanguageMetadataService.equals(TestArtifactsCatalog.expressionLanguageMetadataServiceJarFile)) {
            this.expressionLanguageMetadataService.delete();
            this.expressionLanguageMetadataService = null;
        }
    }

    public void reset() {
        this.schedulerService = null;
        this.httpService = null;
        this.expressionLanguageService = null;
        this.expressionLanguageMetadataService = null;
        this.expressionLanguageMetadataServiceDisabled = false;
    }
}

