/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.mule.runtime.config.api.properties.PropertiesResolverUtils;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.infrastructure.deployment.FakeMuleServer;
import org.mule.test.infrastructure.deployment.TestArtifactsCatalog;
import org.mule.test.infrastructure.deployment.TestServicesSetup;

public class AbstractFakeMuleServerTestCase
extends AbstractMuleTestCase {
    @ClassRule
    public static SystemProperty duplicateProvidersLax = new SystemProperty(PropertiesResolverUtils.class.getName() + ".duplicateProvidersLax", "true");
    @Rule
    public SystemProperty jvmVersionExtensionEnforcementLoose = new SystemProperty("mule.jvm.version.extension.enforcement", "LOOSE");
    @Rule
    public SystemProperty classloaderContainerJpmsModuleLayer = new SystemProperty("mule.classloader.container.jpmsModuleLayer", "" + this.classloaderContainerJpmsModuleLayer());
    @Rule
    public TemporaryFolder muleHome = new TemporaryFolder();
    public static final TemporaryFolder compilerWorkFolder = new TemporaryFolder();
    protected static TestArtifactsCatalog testArtifactsCatalog = new TestArtifactsCatalog(compilerWorkFolder);
    protected static TestServicesSetup testServicesSetup = new TestServicesSetup(compilerWorkFolder);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)compilerWorkFolder).around((TestRule)testArtifactsCatalog).around((TestRule)testServicesSetup);
    private static boolean areServicesInitialised = false;
    private static File cachedSchedulerService = null;
    private static File cachedHttpService = null;
    private static File cachedELService = null;
    private static File cachedELMService = null;
    protected FakeMuleServer muleServer;

    protected List<MuleCoreExtension> getCoreExtensions() {
        return new LinkedList<MuleCoreExtension>();
    }

    @Before
    public void setUp() throws Exception {
        this.muleServer = new FakeMuleServer(this.muleHome.getRoot().getAbsolutePath(), this.getCoreExtensions());
        testServicesSetup.initNotOverriddenServices();
        this.initialiseServicesIfNeeded();
        this.muleServer.addZippedService(cachedSchedulerService);
        this.muleServer.addZippedService(cachedHttpService);
        this.muleServer.addZippedService(cachedELService);
        if (this.addExpressionLanguageMetadataService()) {
            this.muleServer.addZippedService(cachedELMService);
        }
    }

    protected boolean classloaderContainerJpmsModuleLayer() {
        return false;
    }

    protected boolean addExpressionLanguageMetadataService() {
        return true;
    }

    @After
    public void tearDown() throws Exception {
        if (this.muleServer != null) {
            this.muleServer.stop();
            this.muleServer = null;
        }
        LogManager.shutdown();
    }

    private void initialiseServicesIfNeeded() throws IOException {
        if (!areServicesInitialised) {
            areServicesInitialised = true;
            cachedSchedulerService = this.getSchedulerService();
            cachedHttpService = this.getHttpService();
            cachedELService = this.getExpressionLanguageService();
            if (this.addExpressionLanguageMetadataService()) {
                cachedELMService = this.getExpressionLanguageMetadataService();
            }
        }
    }

    @AfterClass
    public static void nullifyCachedServices() {
        areServicesInitialised = false;
        cachedSchedulerService = null;
        cachedHttpService = null;
        cachedELService = null;
        cachedELMService = null;
    }

    protected File getExpressionLanguageService() throws IOException {
        return testServicesSetup.getExpressionLanguageService();
    }

    protected File getExpressionLanguageMetadataService() throws IOException {
        return testServicesSetup.getExpressionLanguageMetadataService();
    }

    protected File getSchedulerService() throws IOException {
        return testServicesSetup.getSchedulerService();
    }

    protected File getHttpService() throws IOException {
        return testServicesSetup.getHttpService();
    }
}

