/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

public class FileContainsInLine
extends TypeSafeMatcher<File> {
    private final Matcher<String> stringMatcher;

    @Factory
    public static Matcher<File> hasLine(Matcher<String> matcher) {
        return new FileContainsInLine(matcher);
    }

    private FileContainsInLine(Matcher<String> matcher) {
        this.stringMatcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("a file where a line ").appendDescriptionOf(this.stringMatcher);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matchesSafely(File file) {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());){
            String line;
            do {
                if ((line = reader.readLine()) == null) return false;
            } while (!this.stringMatcher.matches((Object)line));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Assert.fail((String)String.format("Exception %s caught while reading the file %s trying to match its line with the matcher %s", e.getMessage(), file.getAbsolutePath(), this.stringMatcher.toString()));
            return false;
        }
    }
}

