/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import groovy.lang.GroovyShell;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyScriptExecutor
implements TestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptExecutor.class);
    private final String scriptPath;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, Supplier<String>> propertiesUsingLambdas = new HashMap<String, Supplier<String>>();

    public static Builder builder(String scriptPath) {
        return new Builder(scriptPath);
    }

    public GroovyScriptExecutor(String scriptPath, Map<String, String> properties, Map<String, Supplier<String>> propertiesUsingLambdas) {
        this(scriptPath);
        this.properties = properties;
        this.propertiesUsingLambdas = propertiesUsingLambdas;
    }

    protected GroovyScriptExecutor(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                GroovyScriptExecutor.this.executeGroovyScript();
                base.evaluate();
            }
        };
    }

    private void executeGroovyScript() {
        try {
            GroovyShell shell = new GroovyShell();
            this.resolvePropertiesUsingLambdas();
            this.properties.forEach((key, value) -> shell.setProperty(key, value));
            shell.evaluate((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(this.scriptPath)));
            LOGGER.info("Groovy script executed");
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException("Compilation error were found on: " + this.scriptPath, e);
        }
    }

    private void resolvePropertiesUsingLambdas() {
        this.propertiesUsingLambdas.forEach((propertyName, propertySupplierLambda) -> this.properties.put((String)propertyName, (String)propertySupplierLambda.get()));
    }

    public static class Builder {
        private String scriptPath;
        private Map<String, String> properties = new HashMap<String, String>();
        private Map<String, Supplier<String>> propertiesUsingLambdas = new HashMap<String, Supplier<String>>();

        Builder(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        public Builder withProperty(String property, String value) {
            this.properties.put(property, value);
            return this;
        }

        public Builder withPropertyUsingLambda(String property, Supplier<String> propertySupplier) {
            this.propertiesUsingLambdas.put(property, propertySupplier);
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            properties.putAll(properties);
            return this;
        }

        public GroovyScriptExecutor build() {
            return new GroovyScriptExecutor(this.scriptPath, this.properties, this.propertiesUsingLambdas);
        }
    }
}

