/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.server.ftp;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.mule.runtime.core.api.util.IOUtils;

public class EmbeddedFtpServer {
    private FtpServer server;
    private final int port;

    public EmbeddedFtpServer(int port) throws Exception {
        this.port = port;
    }

    private Listener createListener(int port) {
        ListenerFactory listenerFactory = this.createListenerFactory(port);
        return listenerFactory.createListener();
    }

    protected ListenerFactory createListenerFactory(int port) {
        ListenerFactory listenerFactory = new ListenerFactory();
        listenerFactory.setPort(port);
        listenerFactory.setIdleTimeout(60000);
        return listenerFactory;
    }

    private void setupUserManagerFactory(FtpServerFactory serverFactory) throws IOException, URISyntaxException {
        PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
        URL usersFile = IOUtils.getResourceAsUrl((String)"users.properties", this.getClass());
        if (usersFile == null) {
            throw new IOException("users.properties file not found in the classpath");
        }
        userManagerFactory.setFile(new File(usersFile.toURI()));
        serverFactory.setUserManager(userManagerFactory.createUserManager());
    }

    public void start() {
        FtpServerFactory serverFactory = new FtpServerFactory();
        serverFactory.addListener("default", this.createListener(this.port));
        try {
            this.setupUserManagerFactory(serverFactory);
            this.server = serverFactory.createServer();
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start server", e);
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

