/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import java.io.File;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.runtime.core.util.FileUtils;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.infrastructure.server.ftp.EmbeddedFtpServer;

public class FtpServer
extends ExternalResource {
    private final File baseDir;
    protected final DynamicPort dynamicPort;
    private final SystemProperty dynamicPortSystemProperty;
    private EmbeddedFtpServer server = null;

    public FtpServer(String ftpServerPortName, File baseDir) {
        this.baseDir = baseDir;
        this.dynamicPort = new DynamicPort(ftpServerPortName + "_PORT");
        this.dynamicPortSystemProperty = new SystemProperty(ftpServerPortName, String.valueOf(this.dynamicPort.getNumber()));
    }

    public Statement apply(Statement base, Description description) {
        base = this.dynamicPort.apply(base, description);
        base = this.dynamicPortSystemProperty.apply(base, description);
        return super.apply(base, description);
    }

    public void start() throws Exception {
        try {
            this.createFtpServerBaseDir();
            this.server = this.createServer();
            this.server.start();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.stopServer();
        this.deleteFtpServerBaseDir();
    }

    protected EmbeddedFtpServer createServer() throws Exception {
        return new EmbeddedFtpServer(this.dynamicPort.getNumber());
    }

    private void stopServer() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not stop FTP server", e);
            }
        }
    }

    private void createFtpServerBaseDir() {
        this.deleteFtpServerBaseDir();
        this.baseDir.mkdirs();
    }

    private void deleteFtpServerBaseDir() {
        FileUtils.deleteTree((File)this.baseDir);
    }

    public int getPort() {
        return this.dynamicPort.getNumber();
    }
}

