/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.util.concurrent.Latch;
import org.mule.test.infrastructure.process.CommandServer;
import org.mule.test.infrastructure.process.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProcess
implements CommandServer.CommandListener {
    private Logger logger = LoggerFactory.getLogger(TestProcess.class);
    private final Latch clientSocketAcceptedLatch = new Latch();
    private final Latch contextStartedLatch = new Latch();
    private Process process;
    private String instanceId;
    private ServerSocket loggerSocket;
    private CommandServer commandServer;
    private Thread loggerThread;

    public TestProcess(String instanceId, int loggerServerPort, int commandServerPort) {
        this.instanceId = instanceId;
        this.createLoggerServerSocket(loggerServerPort);
        this.createCommandServer(commandServerPort);
    }

    public void destroyQuietly() {
        try {
            this.logger.info(String.format("# Destroying process for instance %s #", this.instanceId));
            this.loggerThread.interrupt();
            this.closeQuietly(this.loggerSocket);
            this.commandServer.stop();
            this.process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void commandReceived(String command) {
        if (command.equals("MuleContext:started")) {
            this.contextStartedLatch.release();
        }
    }

    public void waitUntilStarted() throws InterruptedException {
        this.waitUntilStarted(30);
    }

    public void waitUntilStarted(int contextStartedTiemout) throws InterruptedException {
        if (!this.clientSocketAcceptedLatch.await((long)TestUtils.getTimeout(20), TimeUnit.SECONDS)) {
            throw new IllegalStateException(String.format("Client process %s didn not connect connect to logger service", this.instanceId));
        }
        if (!this.contextStartedLatch.await((long)TestUtils.getTimeout(contextStartedTiemout), TimeUnit.SECONDS)) {
            throw new RuntimeException(String.format("Process %s didn not start within 30 seconds", this.instanceId));
        }
    }

    private void createCommandServer(int commandServerPort) {
        try {
            this.logger.info("Creating command server on port: " + commandServerPort + " for instance " + this.instanceId);
            this.commandServer = new CommandServer(commandServerPort);
            this.commandServer.start();
            this.commandServer.setCommandListener(this);
        }
        catch (IOException e) {
            if (this.commandServer != null) {
                this.commandServer.stop();
            }
            throw new RuntimeException(e);
        }
    }

    private void createLoggerServerSocket(int loggerServerPort) {
        try {
            this.logger.info("Creating logger service on port: " + loggerServerPort);
            this.loggerSocket = new ServerSocket(loggerServerPort, 0, InetAddress.getByName("localhost"));
            this.loggerThread = new Thread(String.format("Process %s logger", this.instanceId)){

                @Override
                public void run() {
                    try {
                        Socket processClientConnection = TestProcess.this.loggerSocket.accept();
                        TestProcess.this.clientSocketAcceptedLatch.release();
                        BufferedReader processClientLogEntriesInputStream = new BufferedReader(new InputStreamReader(processClientConnection.getInputStream()));
                        while (!Thread.interrupted()) {
                            String logLine = processClientLogEntriesInputStream.readLine();
                            if (logLine == null) {
                                try {
                                    Thread.sleep(200L);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    TestProcess.this.closeQuietly(TestProcess.this.loggerSocket);
                                    return;
                                }
                            }
                            TestProcess.this.logger.info(logLine);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        TestProcess.this.closeQuietly(TestProcess.this.loggerSocket);
                    }
                }
            };
            this.loggerThread.setDaemon(true);
            this.loggerThread.start();
        }
        catch (IOException e) {
            this.closeQuietly(this.loggerSocket);
            throw new RuntimeException(e);
        }
    }

    private void closeQuietly(ServerSocket loggerSocket) {
        try {
            if (loggerSocket != null) {
                loggerSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setProcess(Process process) {
        this.process = process;
    }
}

