/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.concurrent.Latch;
import org.mule.runtime.module.deployment.api.DeploymentListener;

public class ApplicationStartedDeploymentListener
implements DeploymentListener {
    public static final int APPLICATION_STARTED_TIMEOUT_IN_SECONDS = 20;
    private Latch applicationStartedLatch = new Latch();

    public void waitUntilApplicationDeployed() {
        try {
            if (!this.applicationStartedLatch.await(20L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Application didn't start within 20 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void onDeploymentStart(String artifactName) {
    }

    public void onDeploymentSuccess(String artifactName) {
        if (artifactName.equals("test-app")) {
            this.applicationStartedLatch.release();
        }
    }

    public void onDeploymentFailure(String artifactName, Throwable cause) {
    }

    public void onUndeploymentStart(String artifactName) {
    }

    public void onUndeploymentSuccess(String artifactName) {
    }

    public void onUndeploymentFailure(String artifactName, Throwable cause) {
    }

    public void onMuleContextCreated(String artifactName, MuleContext context) {
    }

    public void onMuleContextInitialised(String artifactName, MuleContext context) {
    }

    public void onMuleContextConfigured(String artifactName, MuleContext context) {
    }
}

