/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import com.jayway.awaitility.Awaitility;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.test.infrastructure.process.rules.MuleInstallation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleDeployment
extends MuleInstallation {
    private static final long POLL_DELAY_MILLIS = 1000L;
    private static final String DEFAULT_DEPLOYMENT_TIMEOUT = "60000";
    private static final boolean STOP_ON_EXIT = Boolean.parseBoolean(System.getProperty("mule.test.stopOnExit", "true"));
    private static final boolean DEBUGGING_ENABLED = Boolean.parseBoolean(System.getProperty("mule.test.debug", "false"));
    private static final String DEBUG_PORT = "5005";
    private static Logger logger = LoggerFactory.getLogger(MuleDeployment.class);
    private static PollingProber prober;
    private String locationSuffix = "";
    private int deploymentTimeout = Integer.parseInt(System.getProperty("mule.test.deployment.timeout", "60000"));
    private List<String> applications = new ArrayList<String>();
    private List<String> domains = new ArrayList<String>();
    private List<String> libraries = new ArrayList<String>();
    private MuleProcessController mule;
    private Map<String, String> properties = new HashMap<String, String>();

    public static Builder builder() {
        return new Builder();
    }

    protected MuleDeployment() {
    }

    private String[] toArray(Map<String, String> map) {
        ArrayList values = new ArrayList();
        map.forEach((key, value) -> values.add(key + "=" + value));
        return values.toArray(new String[0]);
    }

    @Override
    public Statement apply(final Statement base, Description description) {
        this.location = description.getTestClass().getSimpleName() + this.locationSuffix;
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    MuleDeployment.this.before();
                    base.evaluate();
                }
                finally {
                    MuleDeployment.this.after();
                }
            }
        };
    }

    @Override
    protected void before() throws Throwable {
        super.before();
        prober = new PollingProber((long)this.deploymentTimeout, 1000L);
        this.mule = new MuleProcessController(this.getMuleHome());
        try {
            this.doBefore();
        }
        catch (Error e) {
            this.logServerError(e);
        }
    }

    private void logServerError(Error e) throws IOException {
        logger.error("====================== Server log ===============================");
        Files.lines(this.mule.getLog().toPath()).forEach(arg_0 -> ((Logger)logger).error(arg_0));
        logger.error("=================================================================");
        logger.error("Cause: " + e.getMessage());
    }

    private void doBefore() {
        if (this.mule.isRunning()) {
            logger.warn("Mule Server was already running");
            this.libraries.forEach(library -> this.mule.addLibrary(new File((String)library)));
            logger.info("Redeploying domains");
            this.domains.forEach(domain -> this.redeployDomain((String)domain));
            logger.info("Redeploying applications");
            this.applications.forEach(application -> this.redeploy((String)application));
            logger.info("Redeployment successful");
        } else {
            this.libraries.forEach(library -> this.mule.addLibrary(new File((String)library)));
            this.domains.forEach(domain -> this.mule.deployDomain((String)domain));
            this.applications.forEach(application -> this.mule.deploy((String)application));
            logger.info("Starting Mule Server");
            if (DEBUGGING_ENABLED) {
                this.setupDebugging();
            }
            this.mule.start(this.toArray(this.properties));
            this.domains.forEach(domain -> this.checkDomainIsDeployed(this.getName((String)domain)));
            this.applications.forEach(application -> this.checkAppIsDeployed(this.getName((String)application)));
            logger.info("Deployment successful");
        }
    }

    private void setupDebugging() {
        this.mule.addConfProperty("-Xdebug");
        this.mule.addConfProperty("-Xnoagent");
        this.mule.addConfProperty("-Djava.compiler=NONE");
        this.mule.addConfProperty("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
        logger.info("Listening for remote debugger to attach at port: 5005");
    }

    private void redeployDomain(String domain) {
        this.mule.undeployDomain(this.getName(domain));
        Awaitility.await((String)("Domain " + domain + " is undeployed")).atMost((long)this.deploymentTimeout, TimeUnit.MILLISECONDS).until(() -> !this.mule.isDomainDeployed(this.getName(domain)));
        this.mule.deployDomain(domain);
        Awaitility.await((String)("Domain " + domain + " is deployed")).atMost((long)this.deploymentTimeout, TimeUnit.MILLISECONDS).until(() -> this.mule.isDomainDeployed(this.getName(domain)));
    }

    private void redeploy(String application) {
        this.mule.undeploy(this.getName(application));
        Awaitility.await((String)("Application " + application + " is undeployed")).atMost((long)this.deploymentTimeout, TimeUnit.MILLISECONDS).until(() -> !this.mule.isDeployed(this.getName(application)));
        this.mule.deploy(application);
        Awaitility.await((String)("Application " + application + " is deployed")).atMost((long)this.deploymentTimeout, TimeUnit.MILLISECONDS).until(() -> this.mule.isDeployed(this.getName(application)));
    }

    private String getName(String application) {
        return FilenameUtils.removeExtension((String)FilenameUtils.getName((String)application));
    }

    private void checkAppIsDeployed(final String appName) {
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                return MuleDeployment.this.mule.isDeployed(appName);
            }

            public String describeFailure() {
                return "Application " + appName + " is not deployed after " + MuleDeployment.this.deploymentTimeout / 1000 + " seconds.";
            }
        });
    }

    private void checkDomainIsDeployed(final String domainName) {
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                return MuleDeployment.this.mule.isDomainDeployed(domainName);
            }

            public String describeFailure() {
                return "Domain " + domainName + " is not deployed after " + MuleDeployment.this.deploymentTimeout / 1000 + " seconds.";
            }
        });
    }

    @Override
    protected void after() {
        if (STOP_ON_EXIT) {
            if (this.mule.isRunning()) {
                logger.info("Stopping Mule Server");
                this.mule.stop(new String[0]);
            }
            super.after();
        }
    }

    public static class Builder {
        MuleDeployment deployment = new MuleDeployment();

        Builder() {
        }

        public MuleDeployment deploy() {
            return this.deployment;
        }

        public Builder timeout(int seconds) {
            this.deployment.deploymentTimeout = seconds * 1000;
            return this;
        }

        public Builder withProperty(String property, String value) {
            this.deployment.properties.put(property, value);
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            if (this.deployment.properties.size() != 0) {
                throw new IllegalStateException("Properties map already has properties defined. Can't overwrite all properties");
            }
            this.deployment.properties = properties;
            return this;
        }

        public Builder withApplications(String ... applications) {
            Collections.addAll(this.deployment.applications, applications);
            return this;
        }

        public Builder locationSuffix(String suffix) {
            this.deployment.locationSuffix = suffix;
            return this;
        }

        public Builder withDomains(String ... domains) {
            Collections.addAll(this.deployment.domains, domains);
            return this;
        }

        public Builder withLibraries(String ... libraries) {
            Collections.addAll(this.deployment.libraries, libraries);
            return this;
        }
    }
}

