/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandServer {
    public static final String MULE_CONTEXT_STARTED_COMMAND = "MuleContext:started";
    private final Logger logger = LoggerFactory.getLogger(CommandServer.class);
    private final int serverPort;
    private ServerSocket commandSocket;
    private List<String> pendingCommands = new ArrayList<String>();
    private CommandListener commandListener;
    private Thread commandServerThread;

    public CommandServer(int serverPort) {
        this.serverPort = serverPort;
    }

    public synchronized void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
        for (String command : this.pendingCommands) {
            this.commandListener.commandReceived(command);
        }
    }

    public void start() throws IOException {
        this.logger.debug("Trying to create server socket for command service to port: " + this.serverPort);
        this.commandSocket = new ServerSocket(this.serverPort, 0, InetAddress.getByName("localhost"));
        this.commandServerThread = new Thread("Command-Server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    Socket processClientConnection = CommandServer.this.commandSocket.accept();
                    BufferedReader processClientLogEntriesInputStream = new BufferedReader(new InputStreamReader(processClientConnection.getInputStream()));
                    while (!Thread.interrupted()) {
                        String commandLine = processClientLogEntriesInputStream.readLine();
                        if (commandLine == null) {
                            try {
                                Thread.sleep(200L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                CommandServer.this.closeQuietly(CommandServer.this.commandSocket);
                                return;
                            }
                        }
                        CommandServer.this.logger.info("Command from external process received: " + commandLine);
                        1 var4_5 = this;
                        synchronized (var4_5) {
                            if (CommandServer.this.commandListener == null) {
                                CommandServer.this.pendingCommands.add(commandLine);
                            } else {
                                CommandServer.this.commandListener.commandReceived(commandLine);
                            }
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    CommandServer.this.closeQuietly(CommandServer.this.commandSocket);
                }
            }
        };
        this.commandServerThread.setDaemon(true);
        this.commandServerThread.start();
    }

    private void closeQuietly(ServerSocket loggerSocket) {
        try {
            if (loggerSocket != null) {
                loggerSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.closeQuietly(this.commandSocket);
        if (this.commandServerThread != null) {
            this.commandServerThread.interrupt();
        }
    }

    public static interface CommandListener {
        public void commandReceived(String var1);
    }
}

