/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.File;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.mule.test.infrastructure.process.MuleProcessController;

public class VerifyLogWithMatcher
extends TypeSafeMatcher<MuleProcessController> {
    private String app;
    private Matcher<File> fileMatcher;

    @Factory
    public static Matcher<MuleProcessController> log(Matcher<File> matcher) {
        return new VerifyLogWithMatcher(matcher);
    }

    @Factory
    public static Matcher<MuleProcessController> log(String appName, Matcher<File> matcher) {
        return new VerifyLogWithMatcher(appName, matcher);
    }

    private VerifyLogWithMatcher(Matcher<File> matcher) {
        this.fileMatcher = matcher;
    }

    private VerifyLogWithMatcher(String appName, Matcher<File> matcher) {
        this.app = appName;
        this.fileMatcher = matcher;
    }

    public boolean matchesSafely(MuleProcessController muleProcessController) {
        File logFile = this.app == null ? muleProcessController.getLog() : muleProcessController.getLog(this.app);
        return this.fileMatcher.matches((Object)logFile);
    }

    public void describeTo(Description description) {
        String message = this.app == null ? "mule log that has " : String.format("%s application log that have ", this.app);
        description.appendText(message).appendDescriptionOf(this.fileMatcher);
    }
}

