/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public class DistroUnzipper {
    private File file;
    private File destDir;
    private File rootFile;

    public DistroUnzipper(File file, File destDir) {
        this.file = file;
        this.destDir = destDir;
    }

    public File muleHome() {
        return this.rootFile;
    }

    public DistroUnzipper unzip() throws IOException {
        try (ZipFile zip = new ZipFile(this.file);){
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            ZipEntry root = zipFileEntries.nextElement();
            this.rootFile = new File(this.destDir, root.getName());
            this.rootFile.mkdirs();
            this.chmodRwx(this.rootFile);
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                File destFile = new File(this.destDir, entry.getName());
                if (entry.isDirectory()) {
                    destFile.mkdir();
                    continue;
                }
                FileUtils.copyInputStreamToFile((InputStream)zip.getInputStream(entry), (File)destFile);
                this.chmodRwx(destFile);
            }
            DistroUnzipper distroUnzipper = this;
            return distroUnzipper;
        }
    }

    private void chmodRwx(File destFile) {
        destFile.setExecutable(true, false);
        destFile.setWritable(true, false);
        destFile.setReadable(true, false);
    }
}

