/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.tck.junit4.rule.DynamicPort;

public class ActiveMQBroker
extends ExternalResource {
    protected final DynamicPort dynamicPort;
    private final String connectorUrl;
    private BrokerService broker;
    private TransportConnector transportConnector;

    public ActiveMQBroker(String amqBrokerPortName) {
        this.dynamicPort = new DynamicPort(amqBrokerPortName);
        this.connectorUrl = "tcp://localhost:" + this.dynamicPort.getValue();
    }

    public Statement apply(Statement base, Description description) {
        base = this.dynamicPort.apply(base, description);
        return super.apply(base, description);
    }

    public void start() {
        this.broker = new BrokerService();
        try {
            this.broker.setUseJmx(false);
            this.broker.setPersistent(false);
            this.transportConnector = this.broker.addConnector(this.connectorUrl);
            this.broker.start(true);
            this.broker.waitUntilStarted();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getConnectorUrl() {
        return this.connectorUrl;
    }

    public int getConnectionsCount() {
        return this.transportConnector.getConnections().size();
    }
}

