/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.mule.tck.functional.AssertionMessageProcessor;

public class FlowAssert {
    private static Map<String, List<AssertionMessageProcessor>> assertions = new TreeMap<String, List<AssertionMessageProcessor>>();

    public static void verify() throws Exception {
        for (List<AssertionMessageProcessor> flowAssertions : assertions.values()) {
            for (AssertionMessageProcessor assertion : flowAssertions) {
                assertion.verify();
            }
        }
    }

    public static void verify(String flowName) throws Exception {
        List<AssertionMessageProcessor> flowAssertions = assertions.get(flowName);
        if (flowAssertions != null) {
            for (AssertionMessageProcessor assertion : flowAssertions) {
                assertion.verify();
            }
        }
    }

    static void addAssertion(String flowName, AssertionMessageProcessor assertion) {
        if (assertions.get(flowName) == null) {
            assertions.put(flowName, new ArrayList());
        }
        assertions.get(flowName).add(assertion);
    }

    public static void reset() {
        assertions = new TreeMap<String, List<AssertionMessageProcessor>>();
    }
}

