/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.tck;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.transport.Connector;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.CounterCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.functional.ResponseWriterCallback;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transport.ConfigurableKeyedObjectPool;
import org.mule.transport.ConfigurableKeyedObjectPoolFactory;
import org.mule.transport.DefaultConfigurableKeyedObjectPool;
import org.mule.transport.DefaultConfigurableKeyedObjectPoolFactory;

public class MuleTestNamespaceTestCase
extends AbstractServiceAndFlowTestCase {
    public MuleTestNamespaceTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "test-namespace-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "test-namespace-config-flow.xml"});
    }

    @Test
    public void testComponent1Config() throws Exception {
        Object object = this.getComponent("testService1");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof FunctionalTestComponent));
        FunctionalTestComponent ftc = (FunctionalTestComponent)object;
        Assert.assertFalse((boolean)ftc.isEnableMessageHistory());
        Assert.assertFalse((boolean)ftc.isEnableNotifications());
        Assert.assertNull((Object)ftc.getAppendString());
        Assert.assertEquals((Object)"Foo Bar Car Jar", (Object)ftc.getReturnData());
        Assert.assertNotNull((Object)ftc.getEventCallback());
        Assert.assertTrue((boolean)(ftc.getEventCallback() instanceof CounterCallback));
    }

    @Test
    public void testComponent2Config() throws Exception {
        String testData = this.loadResourceAsString("test-data.txt");
        Object object = this.getComponent("testService2");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof FunctionalTestComponent));
        FunctionalTestComponent ftc = (FunctionalTestComponent)object;
        Assert.assertTrue((boolean)ftc.isThrowException());
        Assert.assertNotNull((Object)ftc.getExceptionToThrow());
        Assert.assertTrue((boolean)ftc.getExceptionToThrow().isAssignableFrom(IOException.class));
        Assert.assertEquals((Object)"boom", (Object)ftc.getExceptionText());
        Assert.assertEquals((Object)testData, (Object)ftc.getReturnData());
        Assert.assertTrue((boolean)ftc.isEnableMessageHistory());
        Assert.assertTrue((boolean)ftc.isEnableNotifications());
        Assert.assertNull((Object)ftc.getAppendString());
        Assert.assertNotNull((Object)ftc.getEventCallback());
        Assert.assertTrue((boolean)(ftc.getEventCallback() instanceof ResponseWriterCallback));
    }

    @Test
    public void testComponent3Config() throws Exception {
        Object object = this.getComponent("testService3");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof FunctionalTestComponent));
        FunctionalTestComponent ftc = (FunctionalTestComponent)object;
        Assert.assertFalse((boolean)ftc.isEnableMessageHistory());
        Assert.assertTrue((boolean)ftc.isEnableNotifications());
        Assert.assertEquals((Object)" #[context:serviceName]", (Object)ftc.getAppendString());
        Assert.assertNull((Object)ftc.getReturnData());
        Assert.assertNull((Object)ftc.getEventCallback());
    }

    @Test
    public void testConnectorUsingDefaultDispatcherPoolFactory() {
        Connector connector = muleContext.getRegistry().lookupConnector("testConnectorWithDefaultFactory");
        Assert.assertTrue((boolean)(connector instanceof TestConnector));
        TestConnector testConnector = (TestConnector)connector;
        Assert.assertEquals(DefaultConfigurableKeyedObjectPoolFactory.class, testConnector.getDispatcherPoolFactory().getClass());
        Assert.assertEquals(DefaultConfigurableKeyedObjectPool.class, testConnector.getDispatchers().getClass());
    }

    @Test
    public void testConnectorUsingOverriddenDispatcherPoolFactory() {
        Connector connector = muleContext.getRegistry().lookupConnector("testConnectorWithOverriddenFactory");
        Assert.assertTrue((boolean)(connector instanceof TestConnector));
        TestConnector testConnector = (TestConnector)connector;
        Assert.assertEquals(StubDispatcherPoolFactory.class, testConnector.getDispatcherPoolFactory().getClass());
        Assert.assertEquals(StubConfigurableKeyedObjectPool.class, testConnector.getDispatchers().getClass());
    }

    public static class StubDispatcherPoolFactory
    implements ConfigurableKeyedObjectPoolFactory {
        public ConfigurableKeyedObjectPool createObjectPool() {
            return new StubConfigurableKeyedObjectPool();
        }
    }

    public static class StubConfigurableKeyedObjectPool
    extends DefaultConfigurableKeyedObjectPool {
    }
}

