/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.source.MessageSource;
import org.mule.construct.Flow;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.processor.IdempotentRedeliveryPolicy;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.store.SimpleMemoryObjectStore;

public class RedeliveryPolicyNamespaceHandlerTestCase
extends FunctionalTestCase {
    public RedeliveryPolicyNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "org/mule/test/config/redelivery-policy-config.xml";
    }

    @Test
    public void testInMemoryObjectStore() throws Exception {
        IdempotentRedeliveryPolicy filter = this.redeliveryPolicyFromFlow("inMemoryStore");
        Assert.assertNotNull((Object)filter.getTheFailedMessageProcessor());
        Assert.assertEquals((long)12L, (long)filter.getMaxRedeliveryCount());
        Assert.assertNull((Object)filter.getIdExpression());
    }

    @Test
    public void testSimpleTextFileStore() throws Exception {
        IdempotentRedeliveryPolicy filter = this.redeliveryPolicyFromFlow("simpleTextFileStore");
        Assert.assertEquals((Object)"#[message:id]", (Object)filter.getIdExpression());
        Assert.assertNotNull((Object)filter.getTheFailedMessageProcessor());
        Assert.assertEquals((long)5L, (long)filter.getMaxRedeliveryCount());
    }

    @Test
    public void testCustomObjectStore() throws Exception {
        IdempotentRedeliveryPolicy filter = this.redeliveryPolicyFromFlow("customObjectStore");
        Assert.assertNotNull((Object)filter.getTheFailedMessageProcessor());
        Assert.assertEquals((long)5L, (long)filter.getMaxRedeliveryCount());
        Assert.assertNull((Object)filter.getIdExpression());
    }

    private IdempotentRedeliveryPolicy redeliveryPolicyFromFlow(String flowName) throws Exception {
        FlowConstruct flow = this.getFlowConstruct(flowName);
        Assert.assertTrue((boolean)(flow instanceof Flow));
        MessageSource source = ((Flow)flow).getMessageSource();
        Assert.assertTrue((boolean)(source instanceof InboundEndpoint));
        AbstractRedeliveryPolicy redeliveryPolicy = ((InboundEndpoint)source).getRedeliveryPolicy();
        Assert.assertTrue((boolean)(redeliveryPolicy instanceof IdempotentRedeliveryPolicy));
        return (IdempotentRedeliveryPolicy)redeliveryPolicy;
    }

    public static class CustomObjectStore
    extends SimpleMemoryObjectStore<Serializable> {
        private String customProperty;

        public String getCustomProperty() {
            return this.customProperty;
        }

        public void setCustomProperty(String value) {
            this.customProperty = value;
        }
    }
}

