/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.MissingResourceException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.config.InvalidMessageFactory;
import org.mule.test.config.TestMessages;

public class MessagesTestCase
extends AbstractMuleTestCase {
    @Test
    public void testMessageLoading() throws Exception {
        Message message = CoreMessages.authFailedForUser((Object)"Fred");
        Assert.assertEquals((Object)"Authentication failed for principal Fred", (Object)message.getMessage());
        Assert.assertEquals((long)135L, (long)message.getCode());
    }

    @Test
    public void testBadBundle() {
        try {
            InvalidMessageFactory.getInvalidMessage();
            Assert.fail((String)"should throw resource bundle not found exception");
        }
        catch (MissingResourceException e) {
            Assert.assertTrue((boolean)e.getMessage().matches(".*Can't find.*bundle.*"));
        }
    }

    @Test
    public void testGoodBundle() {
        Message message = TestMessages.testMessage("one", "two", "three");
        Assert.assertEquals((Object)"Testing, Testing, one, two, three", (Object)message.getMessage());
        Assert.assertEquals((long)1L, (long)message.getCode());
    }
}

