/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.registry.ResolverException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ExceptionHelperTestCase
extends AbstractMuleTestCase {
    @Test
    public void testNestedExceptionRetreval() throws Exception {
        Exception testException = this.getException();
        Throwable t = ExceptionHelper.getRootException((Throwable)testException);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)"blah", (Object)t.getMessage());
        Assert.assertNull((Object)t.getCause());
        t = ExceptionHelper.getRootMuleException((Throwable)testException);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)"bar", (Object)t.getMessage());
        Assert.assertNotNull((Object)t.getCause());
        List l = ExceptionHelper.getExceptionsAsList((Throwable)testException);
        Assert.assertEquals((long)3L, (long)l.size());
        Map info = ExceptionHelper.getExceptionInfo((Throwable)testException);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertNotNull(info.get("JavaDoc"));
    }

    @Test
    public void testSummarizeWithDepthBeyondStackTraceLength() {
        Exception exception = this.getException();
        int numberOfStackFrames = exception.getStackTrace().length;
        int depth = numberOfStackFrames + 1;
        Throwable summary = ExceptionHelper.summarise((Throwable)exception, (int)depth);
        Assert.assertNotNull((Object)summary);
    }

    @Test
    public void testGetNonMuleExceptionCause() {
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), null)), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), null))), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), (Throwable)new IllegalArgumentException()))), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), (Throwable)new IllegalArgumentException(new NullPointerException())))), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new IllegalArgumentException()), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
    }

    private Exception getException() {
        return new DefaultMuleException(MessageFactory.createStaticMessage((String)"foo"), (Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)"bar"), (Throwable)new Exception("blah")));
    }
}

