/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.Orange;

public class ServiceDescriptorFlowTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/components/service-factory-functional-test-flow.xml";
    }

    @Test
    public void testGenericObjectFactory() throws Exception {
        FlowConstruct c = muleContext.getRegistry().lookupFlowConstruct("orange1");
        Object flow = this.getComponent(c);
        Assert.assertTrue((String)"Flow should be an Orange", (boolean)(flow instanceof Orange));
        Assert.assertEquals((Object)new Integer(10), (Object)((Orange)flow).getSegments());
    }

    @Test
    public void testGenericObjectFactoryWithProperties() throws Exception {
        FlowConstruct c = muleContext.getRegistry().lookupFlowConstruct("orange2");
        Object flow = this.getComponent(c);
        Assert.assertTrue((String)"Flow should be an Orange", (boolean)(flow instanceof Orange));
        Assert.assertEquals((Object)new Integer(8), (Object)((Orange)flow).getSegments());
        Assert.assertEquals((Object)"Florida Sunny", (Object)((Orange)flow).getBrand());
        flow = this.getComponent(c);
        Assert.assertTrue((String)"Service should be an Orange", (boolean)(flow instanceof Orange));
        Assert.assertEquals((Object)new Integer(8), (Object)((Orange)flow).getSegments());
        Assert.assertEquals((Object)"Florida Sunny", (Object)((Orange)flow).getBrand());
    }

    @Test
    public void testSingletonObjectFactory() throws Exception {
        FlowConstruct c = muleContext.getRegistry().lookupFlowConstruct("orange3");
        Object flow = this.getComponent(c);
        Assert.assertTrue((String)"Flow should be an Orange", (boolean)(flow instanceof Orange));
        Assert.assertEquals((Object)new Integer(10), (Object)((Orange)flow).getSegments());
    }

    @Test
    public void testSpringSingleton() throws Exception {
        FlowConstruct c = muleContext.getRegistry().lookupFlowConstruct("orange4");
        Object flow = this.getComponent(c);
        Assert.assertTrue((String)"Flow should be an Orange", (boolean)(flow instanceof Orange));
        Assert.assertEquals((Object)new Integer(10), (Object)((Orange)flow).getSegments());
    }

    @Test
    public void testSpringFactoryBean() throws Exception {
        FlowConstruct c = muleContext.getRegistry().lookupFlowConstruct("orange5");
        Object flow = this.getComponent(c);
        Assert.assertNotNull((Object)flow);
        Assert.assertTrue((String)("Flow should be an Orange but is: " + flow.getClass()), (boolean)(flow instanceof Orange));
        Assert.assertEquals((Object)new Integer(8), (Object)((Orange)flow).getSegments());
        Assert.assertEquals((Object)"Florida Sunny", (Object)((Orange)flow).getBrand());
    }

    @Test
    public void testPojoAsFactoryBean() throws Exception {
        FlowConstruct c = muleContext.getRegistry().lookupFlowConstruct("orange6");
        Object flow = this.getComponent(c);
        Assert.assertNotNull((Object)flow);
        Assert.assertTrue((String)("Flow should be an Orange but is: " + flow.getClass()), (boolean)(flow instanceof Orange));
        Assert.assertEquals((Object)"Florida Sunny", (Object)((Orange)flow).getBrand());
    }
}

