/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.listener;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.PipelineMessageNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.NotificationException;
import org.mule.context.notification.PipelineMessageNotification;
import org.mule.util.concurrent.Latch;

public class FlowExecutionListener {
    private CountDownLatch flowExecutedLatch = new Latch();
    private String flowName;
    private int timeout = 10000;

    public FlowExecutionListener(MuleContext muleContext) {
        this.createFlowExecutionListener(muleContext);
    }

    public FlowExecutionListener(String flowName, MuleContext muleContext) {
        this.flowName = flowName;
        this.createFlowExecutionListener(muleContext);
    }

    private void createFlowExecutionListener(MuleContext muleContext) {
        try {
            muleContext.registerListener((ServerNotificationListener)new PipelineMessageNotificationListener<PipelineMessageNotification>(){

                public void onNotification(PipelineMessageNotification notification) {
                    if (FlowExecutionListener.this.flowName != null && !notification.getResourceIdentifier().equals(FlowExecutionListener.this.flowName)) {
                        return;
                    }
                    if (notification.getAction() == 1804) {
                        FlowExecutionListener.this.flowExecutedLatch.countDown();
                    }
                }
            });
        }
        catch (NotificationException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitUntilFlowIsComplete() {
        try {
            if (!this.flowExecutedLatch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)String.format("Flow %s never completed an execution", this.flowName == null ? "ANY FLOW" : this.flowName));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public FlowExecutionListener setNumberOfExecutionsRequired(int numberOfExecutionsRequired) {
        this.flowExecutedLatch = new CountDownLatch(numberOfExecutionsRequired);
        return this;
    }

    public FlowExecutionListener setTimeoutInMillis(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

