/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;

public class MuleDerbyTestUtils {
    private static final String DERBY_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DERBY_DATASOURCE_CLASS = "org.apache.derby.jdbc.EmbeddedDataSource";

    private MuleDerbyTestUtils() {
    }

    public static String setDerbyHome() {
        return MuleDerbyTestUtils.setDerbyHome("target");
    }

    public static String setDerbyHome(String path) {
        File derbySystemHome = new File(System.getProperty("user.dir"), path);
        System.setProperty("derby.system.home", derbySystemHome.getAbsolutePath());
        return derbySystemHome.getAbsolutePath();
    }

    public static void stopDatabase() throws SQLException {
        try {
            ClassUtils.instanciateClass((String)DERBY_DRIVER_CLASS, (Object[])new Object[0]);
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sqlex) {
            if (!"XJ015".equals(sqlex.getSQLState())) {
                throw sqlex;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void cleanupDerbyDb(String databaseName) throws IOException, SQLException {
        MuleDerbyTestUtils.cleanupDerbyDb(MuleDerbyTestUtils.setDerbyHome(), databaseName);
    }

    public static void cleanupDerbyDb(String derbySystemHome, String databaseName) throws IOException, SQLException {
        MuleDerbyTestUtils.stopDatabase();
        FileUtils.deleteTree((File)new File(derbySystemHome + File.separator + databaseName));
    }

    public static void startDataBase(String databaseName) throws Exception {
        Driver derbyDriver = (Driver)ClassUtils.instanciateClass((String)DERBY_DRIVER_CLASS, (Object[])new Object[0]);
        Method connectMethod = derbyDriver.getClass().getMethod("connect", String.class, Properties.class);
        String connectionName = "jdbc:derby:" + databaseName;
        connectMethod.invoke((Object)derbyDriver, connectionName, null);
    }

    public static void createDataBase(String databaseName) throws SQLException {
        MuleDerbyTestUtils.createDataBase(databaseName, (String[])null);
    }

    public static void createDataBase(String databaseName, String creationSql) throws SQLException {
        MuleDerbyTestUtils.createDataBase(databaseName, new String[]{creationSql});
    }

    public static void createDataBase(String databaseName, String[] creationSql) throws SQLException {
        MuleDerbyTestUtils.createDataBase(databaseName, creationSql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDataBase(String databaseName, String[] creationSql, Properties properties) throws SQLException {
        block7: {
            try {
                String connectionName = "jdbc:derby:" + databaseName + ";create=true";
                Driver derbyDriver = (Driver)ClassUtils.instanciateClass((String)DERBY_DRIVER_CLASS, (Object[])new Object[0]);
                Method connectMethod = derbyDriver.getClass().getMethod("connect", String.class, Properties.class);
                connectMethod.invoke((Object)derbyDriver, connectionName, properties);
                if (creationSql == null) break block7;
                DataSource embeddedDS = (DataSource)ClassUtils.instanciateClass((String)DERBY_DATASOURCE_CLASS, (Object[])new Object[0]);
                Method m = embeddedDS.getClass().getMethod("setDatabaseName", String.class);
                m.invoke((Object)embeddedDS, databaseName);
                Connection con = null;
                try {
                    con = embeddedDS.getConnection();
                    Statement st = con.createStatement();
                    for (String aCreationSql : creationSql) {
                        st.execute(aCreationSql);
                    }
                    con.commit();
                }
                finally {
                    if (con != null && !con.isClosed()) {
                        con.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Error creating the database " + databaseName, ex);
            }
        }
    }

    public static String loadDatabaseName(String propertiesLocation, String propertyName) throws IOException {
        Properties derbyProperties = new Properties();
        URL resource = ClassUtils.getResource((String)propertiesLocation, MuleDerbyTestUtils.class);
        derbyProperties.load(resource.openStream());
        return derbyProperties.getProperty(propertyName);
    }

    public static void defaultDerbyCleanAndInit(String propertiesLocation, String propertyName) throws IOException, SQLException {
        String derbyHome = MuleDerbyTestUtils.setDerbyHome();
        String dbName = MuleDerbyTestUtils.loadDatabaseName(propertiesLocation, propertyName);
        MuleDerbyTestUtils.cleanupDerbyDb(derbyHome, dbName);
        MuleDerbyTestUtils.createDataBase(dbName);
    }
}

