/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import org.mule.AbstractExceptionListener;
import org.mule.api.MuleException;
import org.mule.api.context.ObjectNotFoundException;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.model.Model;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.NestedRouter;
import org.mule.api.routing.NestedRouterCollection;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.ResponseRouter;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.filters.xml.JXPathFilter;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestEntryPointResolverSet;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestInboundTransformer;
import org.mule.tck.testmodels.mule.TestResponseAggregator;
import org.mule.transformer.TransformerUtils;

public abstract class AbstractScriptConfigBuilderTestCase
extends FunctionalTestCase {
    private boolean legacy;

    protected AbstractScriptConfigBuilderTestCase() {
        this(false);
    }

    protected AbstractScriptConfigBuilderTestCase(boolean legacy) {
        this.legacy = legacy;
        this.setDisposeManagerPerSuite(true);
    }

    public void testManagerConfig() throws Exception {
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"true", (Object)muleContext.getRegistry().lookupObject("doCompression"));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)muleContext.getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        TestConnector c = (TestConnector)muleContext.getRegistry().lookupConnector("dummyConnector");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)c);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)c.getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(c.getExceptionListener() instanceof TestExceptionStrategy));
    }

    public void testGlobalEndpointConfig() throws MuleException {
        ImmutableEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("fruitBowlEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getFilter());
        JXPathFilter filter = (JXPathFilter)endpoint.getFilter();
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"name", (String)filter.getPattern());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"bar", (String)filter.getExpectedValue());
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"http://foo.com", filter.getNamespaces().get("foo"));
    }

    public void testEndpointConfig() throws MuleException {
        ImmutableEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("waterMelonEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        ImmutableEndpoint ep = service.getInboundRouter().getEndpoint("Orange");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)ep);
        List responseTransformers = ep.getResponseTransformers();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)responseTransformers);
        AbstractScriptConfigBuilderTestCase.assertFalse((boolean)responseTransformers.isEmpty());
        Object responseTransformer = responseTransformers.get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(responseTransformer instanceof TestCompressionTransformer));
    }

    public void testExceptionStrategy() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)muleContext.getRegistry().lookupModel("main").getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertTrue((((AbstractExceptionListener)service.getExceptionListener()).getEndpoints().size() > 0 ? 1 : 0) != 0);
        Endpoint ep = (Endpoint)((AbstractExceptionListener)service.getExceptionListener()).getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://orange.exceptions", (String)ep.getEndpointURI().toString());
    }

    public void testTransformerConfig() {
        Transformer t = muleContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)t.getReturnClass(), String.class);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        Model model = muleContext.getRegistry().lookupModel("main");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)model);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"main", (String)model.getName());
        if (this.legacy) {
            AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getEntryPointResolverSet() instanceof LegacyEntryPointResolverSet));
        } else {
            AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getEntryPointResolverSet() instanceof TestEntryPointResolverSet));
        }
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getExceptionListener() instanceof TestExceptionStrategy));
        AbstractScriptConfigBuilderTestCase.assertTrue((((AbstractExceptionListener)model.getExceptionListener()).getEndpoints().size() > 0 ? 1 : 0) != 0);
        Endpoint ep = (Endpoint)((AbstractExceptionListener)model.getExceptionListener()).getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://component.exceptions", (String)ep.getEndpointURI().toString());
    }

    public void testOutboundRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getOutboundRouter());
        OutboundRouterCollection router = service.getOutboundRouter();
        AbstractScriptConfigBuilderTestCase.assertNull((Object)router.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)router.getRouters().size());
        OutboundRouter route1 = (OutboundRouter)router.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof OutboundPassThroughRouter));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)route1.getEndpoints().size());
    }

    public void testNestedRouterConfig() throws ObjectNotFoundException {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getNestedRouter());
        NestedRouterCollection router = service.getNestedRouter();
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)router.getRouters().size());
        NestedRouter route1 = (NestedRouter)router.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals(FruitCleaner.class, (Object)route1.getInterface());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"wash", (String)route1.getMethod());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)route1.getEndpoint());
        NestedRouter route2 = (NestedRouter)router.getRouters().get(1);
        AbstractScriptConfigBuilderTestCase.assertEquals(FruitCleaner.class, (Object)route2.getInterface());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"polish", (String)route2.getMethod());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)route1.getEndpoint());
    }

    public void testDescriptorEndpoints() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)service.getOutboundRouter().getRouters().size());
        OutboundRouter router = (OutboundRouter)service.getOutboundRouter().getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)router.getEndpoints().size());
        ImmutableEndpoint endpoint = (ImmutableEndpoint)router.getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"appleInEndpoint", (String)endpoint.getName());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformers());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)endpoint.getTransformers()) instanceof TestCompressionTransformer));
        try {
            endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("appleInEndpoint");
        }
        catch (MuleException e) {
            e.printStackTrace();
            AbstractScriptConfigBuilderTestCase.fail((String)e.getMessage());
        }
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)TransformerUtils.isDefined((List)endpoint.getTransformers()));
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(endpoint.getTransformers().get(0) instanceof TestInboundTransformer));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)service.getInboundRouter().getEndpoints().size());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getInboundRouter().getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(service.getInboundRouter().getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getInboundRouter().getCatchAllStrategy().getEndpoint());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://catch.all", (String)service.getInboundRouter().getCatchAllStrategy().getEndpoint().getEndpointURI().toString());
        endpoint = service.getInboundRouter().getEndpoint("orangeEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"orangeEndpoint", (String)endpoint.getName());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"orangeQ", (String)endpoint.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformers());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)endpoint.getTransformers()) instanceof TestCompressionTransformer));
        try {
            endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("orangeEndpoint");
        }
        catch (MuleException e) {
            e.printStackTrace();
            AbstractScriptConfigBuilderTestCase.fail((String)e.getMessage());
        }
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)TransformerUtils.isDefined((List)endpoint.getTransformers()));
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(endpoint.getTransformers().get(0) instanceof TestInboundTransformer));
    }

    public void testInboundRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getInboundRouter());
        InboundRouterCollection messageRouter = service.getInboundRouter();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)0, (int)messageRouter.getRouters().size());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(messageRouter.getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
    }

    public void testResponseRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getResponseRouter());
        ResponseRouterCollection messageRouter = service.getResponseRouter();
        AbstractScriptConfigBuilderTestCase.assertNull((Object)messageRouter.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)10001, (int)messageRouter.getTimeout());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)messageRouter.getRouters().size());
        ResponseRouter router = (ResponseRouter)messageRouter.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(router instanceof TestResponseAggregator));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)messageRouter.getEndpoints());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
        Endpoint ep = (Endpoint)messageRouter.getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"response1", (String)ep.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)ep.isInbound());
        ep = (Endpoint)messageRouter.getEndpoints().get(1);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"AppleResponseQueue", (String)ep.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)ep.isInbound());
    }
}

