/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import org.mule.MuleException;
import org.mule.RegistryContext;
import org.mule.config.ThreadingProfile;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.model.seda.SedaComponent;
import org.mule.providers.AbstractConnector;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.filters.xml.JXPathFilter;
import org.mule.routing.inbound.IdempotentReceiver;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractScriptConfigBuilderTestCase;
import org.mule.tck.testmodels.mule.TestCatchAllStrategy;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.model.UMOModel;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.routing.UMONestedRouter;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractConfigBuilderTestCase
extends AbstractScriptConfigBuilderTestCase {
    public AbstractConfigBuilderTestCase(boolean legacy) {
        super(legacy);
    }

    public void testManagerConfig() throws Exception {
        super.testManagerConfig();
        AbstractConfigBuilderTestCase.assertNotNull((Object)managementContext.getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        super.testConnectorConfig();
        TestConnector c = (TestConnector)managementContext.getRegistry().lookupConnector("dummyConnector");
        AbstractConfigBuilderTestCase.assertNotNull((Object)c);
        AbstractConfigBuilderTestCase.assertNotNull((Object)c.getExceptionListener());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(c.getExceptionListener() instanceof TestExceptionStrategy));
    }

    public void testGlobalEndpointConfig() {
        super.testGlobalEndpointConfig();
        UMOImmutableEndpoint endpoint = null;
        try {
            endpoint = managementContext.getRegistry().lookupInboundEndpoint("fruitBowlEndpoint", managementContext);
        }
        catch (UMOException e) {
            e.printStackTrace();
            AbstractConfigBuilderTestCase.fail((String)e.getMessage());
        }
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint.getFilter());
        JXPathFilter filter = (JXPathFilter)endpoint.getFilter();
        AbstractConfigBuilderTestCase.assertEquals((String)"name", (String)filter.getPattern());
        AbstractConfigBuilderTestCase.assertEquals((String)"bar", (String)filter.getExpectedValue());
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter.getNamespaces());
        AbstractConfigBuilderTestCase.assertEquals((Object)"http://foo.com", filter.getNamespaces().get("foo"));
    }

    public void testEndpointConfig() {
        super.testEndpointConfig();
        UMOImmutableEndpoint endpoint = null;
        try {
            endpoint = managementContext.getRegistry().lookupInboundEndpoint("waterMelonEndpoint", managementContext);
        }
        catch (UMOException e) {
            e.printStackTrace();
            AbstractConfigBuilderTestCase.fail((String)e.getMessage());
        }
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        UMOComponent component = managementContext.getRegistry().lookupComponent("appleComponent2");
        AbstractConfigBuilderTestCase.assertNotNull((Object)component);
    }

    public void testExceptionStrategy2() {
        UMOComponent component = managementContext.getRegistry().lookupComponent("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)component.getExceptionListener());
        AbstractConfigBuilderTestCase.assertTrue((boolean)DefaultExceptionStrategy.class.isAssignableFrom(component.getExceptionListener().getClass()));
    }

    public void testTransformerConfig() {
        super.testTransformerConfig();
        UMOTransformer t = managementContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        AbstractConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractConfigBuilderTestCase.assertEquals((Object)t.getReturnClass(), (Object)String.class);
        AbstractConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        super.testModelConfig();
        UMOModel model = managementContext.getRegistry().lookupModel("main");
        super.testModelConfig();
    }

    public void testOutboundRouterConfig2() {
        UMOComponent component = managementContext.getRegistry().lookupComponent("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)component.getOutboundRouter());
        UMOOutboundRouterCollection router = component.getOutboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)router.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)router.getRouters().size());
        UMOOutboundRouter route1 = (UMOOutboundRouter)router.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof FilteringOutboundRouter));
        AbstractConfigBuilderTestCase.assertNotNull((Object)((FilteringOutboundRouter)route1).getTransformers());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)((FilteringOutboundRouter)route1).getTransformers()) instanceof TestCompressionTransformer));
        UMOFilter filter = ((FilteringOutboundRouter)route1).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals((Object)String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        UMOOutboundRouter route2 = (UMOOutboundRouter)router.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route2 instanceof FilteringOutboundRouter));
        UMOFilter filter2 = ((FilteringOutboundRouter)route2).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter2);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter2 instanceof AndFilter));
        UMOFilter left = ((AndFilter)filter2).getLeftFilter();
        UMOFilter right = ((AndFilter)filter2).getRightFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)left);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(left instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"the quick brown (.*)", (String)((RegExFilter)left).getPattern());
        AbstractConfigBuilderTestCase.assertNotNull((Object)right);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(right instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"(.*) brown (.*)", (String)((RegExFilter)right).getPattern());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router.getCatchAllStrategy() instanceof TestCatchAllStrategy));
    }

    public void testInboundRouterConfig2() {
        UMOComponent component = managementContext.getRegistry().lookupComponent("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)component.getInboundRouter());
        UMOInboundRouterCollection messageRouter = component.getInboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getRouters().size());
        UMOInboundRouter router = (UMOInboundRouter)messageRouter.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router instanceof SelectiveConsumer));
        SelectiveConsumer sc = (SelectiveConsumer)router;
        AbstractConfigBuilderTestCase.assertNotNull((Object)sc.getFilter());
        UMOFilter filter = sc.getFilter();
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals((Object)String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        UMOInboundRouter router2 = (UMOInboundRouter)messageRouter.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router2 instanceof IdempotentReceiver));
    }

    public void testThreadingConfig() throws MuleException {
        int defaultMaxBufferSize = 42;
        int defaultMaxThreadsActive = 16;
        int defaultMaxThreadsIdle = 3;
        int defaultThreadPoolExhaustedAction = 0;
        int defaultThreadTTL = 60001;
        int connectorMaxBufferSize = 2;
        int componentMaxBufferSize = 6;
        int componentMaxThreadsActive = 12;
        int componentMaxThreadsIdle = 6;
        int componentThreadPoolExhaustedAction = 1;
        ThreadingProfile tp = RegistryContext.getConfiguration().getDefaultThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        tp = RegistryContext.getConfiguration().getDefaultComponentThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        AbstractConnector c = (AbstractConnector)managementContext.getRegistry().lookupConnector("dummyConnector");
        tp = c.getDispatcherThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)connectorMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        UMOComponent component = managementContext.getRegistry().lookupComponent("appleComponent2");
        AbstractConfigBuilderTestCase.assertTrue((String)"component must be SedaComponent to get threading profile", (boolean)(component instanceof SedaComponent));
        tp = ((SedaComponent)component).getThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)componentThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
    }

    public void testEndpointProperties() throws Exception {
        UMOComponent component = managementContext.getRegistry().lookupComponent("appleComponent2");
        MuleEndpoint inEndpoint = (MuleEndpoint)component.getInboundRouter().getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)inEndpoint.getCreateConnector());
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getProperties());
        AbstractConfigBuilderTestCase.assertEquals((Object)"Prop1", inEndpoint.getProperties().get("testEndpointProperty"));
    }

    public void testEnvironmentProperties() {
        AbstractConfigBuilderTestCase.assertEquals((Object)"true", (Object)managementContext.getRegistry().lookupObject("doCompression"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"this was set from the manager properties!", (Object)managementContext.getRegistry().lookupObject("beanProperty1"));
        AbstractConfigBuilderTestCase.assertNotNull((Object)managementContext.getRegistry().lookupObject("OS_Version"));
    }

    public void testNestedRouterProxyCreation() throws ObjectNotFoundException {
        UMOComponent orange = managementContext.getRegistry().lookupComponent("orangeComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)orange);
        UMONestedRouter r = (UMONestedRouter)orange.getNestedRouter().getRouters().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)r);
    }
}

