/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import java.util.HashMap;
import junit.framework.Assert;
import org.mule.RegistryContext;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.model.seda.SedaModel;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEventContext;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.routing.UMORouter;

public abstract class AbstractProviderFunctionalTestCase
extends AbstractMuleTestCase {
    protected static final int NUM_MESSAGES_TO_SEND = 100;
    protected UMOConnector connector;
    protected boolean callbackCalled = false;
    protected int callbackCount = 0;
    protected boolean transacted = false;
    private final Object callbackLock = new Object();
    protected MuleDescriptor descriptor;

    protected void doSetUp() throws Exception {
        RegistryContext.getConfiguration().setDefaultSynchronousEndpoints(true);
        SedaModel model = new SedaModel();
        model.setName("main");
        managementContext.getRegistry().registerModel((UMOModel)model);
        this.callbackCalled = false;
        this.callbackCount = 0;
        this.connector = this.createConnector();
        managementContext.start();
    }

    protected void doTearDown() throws Exception {
        if (this.connector != null) {
            this.connector.dispose();
        }
    }

    public void testSend() throws Exception {
        this.descriptor = AbstractProviderFunctionalTestCase.getTestDescriptor((String)"testComponent", (String)FunctionalTestComponent.class.getName());
        this.initialiseComponent((UMODescriptor)this.descriptor, this.createEventCallback());
        this.sendTestData(100);
        this.afterInitialise();
        this.receiveAndTestResults();
        AbstractProviderFunctionalTestCase.assertTrue((boolean)this.callbackCalled);
    }

    public UMOComponent initialiseComponent(UMODescriptor descriptor, EventCallback callback) throws Exception {
        OutboundPassThroughRouter router = new OutboundPassThroughRouter();
        router.addEndpoint(this.createOutboundEndpoint());
        descriptor.getOutboundRouter().addRouter((UMORouter)router);
        descriptor.getInboundRouter().addEndpoint(this.createInboundEndpoint());
        HashMap<String, EventCallback> props = new HashMap<String, EventCallback>();
        props.put("eventCallback", callback);
        descriptor.setProperties(props);
        managementContext.getRegistry().registerConnector(this.connector);
        descriptor.setModelName("main");
        managementContext.getRegistry().registerService(descriptor);
        UMOModel model = managementContext.getRegistry().lookupModel("main");
        return model.getComponent(descriptor.getName());
    }

    protected UMOEndpoint createOutboundEndpoint() {
        if (this.getOutDest() != null) {
            return new MuleEndpoint("testOut", this.getOutDest(), this.connector, null, "sender", 0, null, null);
        }
        return null;
    }

    protected UMOEndpoint createInboundEndpoint() {
        MuleEndpoint ep = new MuleEndpoint("testIn", this.getInDest(), this.connector, null, "receiver", 0, null, null);
        ep.setSynchronous(true);
        return ep;
    }

    public void afterInitialise() throws Exception {
    }

    public EventCallback createEventCallback() {
        EventCallback callback = new EventCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void eventReceived(UMOEventContext context, Object component) {
                Object object = AbstractProviderFunctionalTestCase.this.callbackLock;
                synchronized (object) {
                    AbstractProviderFunctionalTestCase.this.callbackCalled = true;
                    ++AbstractProviderFunctionalTestCase.this.callbackCount;
                }
                if (!AbstractProviderFunctionalTestCase.this.transacted) {
                    Assert.assertNull((Object)context.getCurrentTransaction());
                } else {
                    Assert.assertNotNull((Object)context.getCurrentTransaction());
                }
            }
        };
        return callback;
    }

    protected abstract void sendTestData(int var1) throws Exception;

    protected abstract void receiveAndTestResults() throws Exception;

    protected abstract UMOEndpointURI getInDest();

    protected abstract UMOEndpointURI getOutDest();

    protected abstract UMOConnector createConnector() throws Exception;
}

