/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.Map;
import org.mule.MuleException;
import org.mule.RegistryContext;
import org.mule.config.ThreadingProfile;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.AbstractConnector;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.filters.xml.JXPathFilter;
import org.mule.routing.inbound.IdempotentReceiver;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractScriptConfigBuilderTestCase;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.mule.TestCatchAllStrategy;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOFilter;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.model.UMOModel;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractConfigBuilderTestCase
extends AbstractScriptConfigBuilderTestCase {
    public void testManagerConfig() throws Exception {
        AbstractConfigBuilderTestCase.assertNotNull((Object)managementContext.getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        TestConnector c = (TestConnector)managementContext.getRegistry().lookupConnector("dummyConnector");
        AbstractConfigBuilderTestCase.assertNotNull((Object)c);
        AbstractConfigBuilderTestCase.assertNotNull((Object)c.getExceptionListener());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(c.getExceptionListener() instanceof TestExceptionStrategy));
    }

    public void testGlobalEndpointConfig() {
        UMOEndpoint endpoint = managementContext.getRegistry().lookupEndpoint("fruitBowlEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint.getFilter());
        JXPathFilter filter = (JXPathFilter)endpoint.getFilter();
        AbstractConfigBuilderTestCase.assertEquals((String)"name", (String)filter.getPattern());
        AbstractConfigBuilderTestCase.assertEquals((String)"bar", (String)filter.getExpectedValue());
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter.getNamespaces());
        AbstractConfigBuilderTestCase.assertEquals((Object)"http://foo.com", filter.getNamespaces().get("foo"));
    }

    public void testEndpointConfig() {
        UMOEndpoint endpoint = managementContext.getRegistry().lookupEndpoint("waterMelonEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        UMODescriptor descriptor = managementContext.getRegistry().lookupService("appleComponent2");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor);
    }

    public void testExceptionStrategy2() {
        UMODescriptor descriptor = managementContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getExceptionListener());
        AbstractConfigBuilderTestCase.assertEquals((Object)DefaultExceptionStrategy.class, descriptor.getExceptionListener().getClass());
    }

    public void testTransformerConfig() {
        UMOTransformer t = managementContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        AbstractConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractConfigBuilderTestCase.assertEquals((Object)t.getReturnClass(), (Object)String.class);
        AbstractConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        UMOModel model = managementContext.getRegistry().lookupModel("main");
        super.testModelConfig();
        AbstractConfigBuilderTestCase.assertTrue((boolean)model.isComponentRegistered("appleComponent"));
        AbstractConfigBuilderTestCase.assertTrue((boolean)model.isComponentRegistered("appleComponent2"));
    }

    public void testOutboundRouterConfig2() {
        UMODescriptor descriptor = managementContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getOutboundRouter());
        UMOOutboundRouterCollection router = descriptor.getOutboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)router.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)router.getRouters().size());
        UMOOutboundRouter route1 = (UMOOutboundRouter)router.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof FilteringOutboundRouter));
        AbstractConfigBuilderTestCase.assertNotNull((Object)((FilteringOutboundRouter)route1).getTransformer());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(((FilteringOutboundRouter)route1).getTransformer() instanceof TestCompressionTransformer));
        UMOFilter filter = ((FilteringOutboundRouter)route1).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals((Object)String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        UMOOutboundRouter route2 = (UMOOutboundRouter)router.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route2 instanceof FilteringOutboundRouter));
        UMOFilter filter2 = ((FilteringOutboundRouter)route2).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter2);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter2 instanceof AndFilter));
        UMOFilter left = ((AndFilter)filter2).getLeftFilter();
        UMOFilter right = ((AndFilter)filter2).getRightFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)left);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(left instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"the quick brown (.*)", (String)((RegExFilter)left).getPattern());
        AbstractConfigBuilderTestCase.assertNotNull((Object)right);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(right instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"(.*) brown (.*)", (String)((RegExFilter)right).getPattern());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router.getCatchAllStrategy() instanceof TestCatchAllStrategy));
    }

    public void testInboundRouterConfig2() {
        UMODescriptor descriptor = managementContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getInboundRouter());
        UMOInboundRouterCollection messageRouter = descriptor.getInboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getRouters().size());
        UMOInboundRouter router = (UMOInboundRouter)messageRouter.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router instanceof SelectiveConsumer));
        SelectiveConsumer sc = (SelectiveConsumer)router;
        AbstractConfigBuilderTestCase.assertNotNull((Object)sc.getFilter());
        UMOFilter filter = sc.getFilter();
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals((Object)String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        UMOInboundRouter router2 = (UMOInboundRouter)messageRouter.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router2 instanceof IdempotentReceiver));
    }

    public void testThreadingConfig() throws MuleException {
        ThreadingProfile tp = RegistryContext.getConfiguration().getDefaultThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)8, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)60001L, (long)tp.getThreadTTL());
        tp = RegistryContext.getConfiguration().getDefaultComponentThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)8, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)60001L, (long)tp.getThreadTTL());
        AbstractConnector c = (AbstractConnector)managementContext.getRegistry().lookupConnector("dummyConnector");
        tp = c.getDispatcherThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)8, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)60000L, (long)tp.getThreadTTL());
        MuleDescriptor descriptor = (MuleDescriptor)managementContext.getRegistry().lookupService("appleComponent2");
        tp = descriptor.getThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)6, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)12, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)6, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)60000L, (long)tp.getThreadTTL());
    }

    public void testPoolingConfig() {
        MuleDescriptor descriptor = (MuleDescriptor)managementContext.getRegistry().lookupService("appleComponent2");
    }

    public void testQueueProfileConfig() {
        MuleDescriptor descriptor = (MuleDescriptor)managementContext.getRegistry().lookupService("orangeComponent");
    }

    public void testEndpointProperties() throws Exception {
        UMODescriptor descriptor = managementContext.getRegistry().lookupService("appleComponent2");
        MuleEndpoint inEndpoint = (MuleEndpoint)descriptor.getInboundRouter().getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)inEndpoint.getCreateConnector());
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getProperties());
        AbstractConfigBuilderTestCase.assertEquals((Object)"Prop1", inEndpoint.getProperties().get("testEndpointProperty"));
    }

    public void testEnvironmentProperties() {
        Map props = managementContext.getRegistry().lookupProperties();
        AbstractConfigBuilderTestCase.assertNotNull((Object)props);
        AbstractConfigBuilderTestCase.assertNotNull(props.get("doCompression"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"true", props.get("doCompression"));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("beanProperty1"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"this was set from the manager properties!", props.get("beanProperty1"));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("OS Version"));
    }

    public void testNestedRouterProxyCreation() throws ObjectNotFoundException {
        Orange orange = (Orange)managementContext.getRegistry().lookupObject((Object)"orange", Orange.class);
        AbstractConfigBuilderTestCase.assertNotNull((Object)orange);
        AbstractConfigBuilderTestCase.assertNotNull((Object)orange.getCleaner());
    }
}

