/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.Map;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.config.pool.CommonsPoolFactory;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.interceptors.LoggingInterceptor;
import org.mule.interceptors.TimerInterceptor;
import org.mule.providers.AbstractConnector;
import org.mule.providers.SimpleRetryConnectionStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.filters.xml.JXPathFilter;
import org.mule.routing.inbound.IdempotentReceiver;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractScriptConfigBuilderTestCase;
import org.mule.tck.testmodels.mule.TestCatchAllStrategy;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.model.UMOModel;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractConfigBuilderTestCase
extends AbstractScriptConfigBuilderTestCase {
    public void testManagerConfig() throws Exception {
        super.testManagerConfig();
        AbstractConfigBuilderTestCase.assertNotNull((Object)MuleManager.getInstance().getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        super.testConnectorConfig();
        TestConnector c = (TestConnector)MuleManager.getInstance().lookupConnector("dummyConnector");
        AbstractConfigBuilderTestCase.assertNotNull((Object)c);
        AbstractConfigBuilderTestCase.assertNotNull((Object)c.getExceptionListener());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(c.getExceptionListener() instanceof TestExceptionStrategy));
        AbstractConfigBuilderTestCase.assertNotNull((Object)c.getConnectionStrategy());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(c.getConnectionStrategy() instanceof SimpleRetryConnectionStrategy));
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)((SimpleRetryConnectionStrategy)c.getConnectionStrategy()).getRetryCount());
        AbstractConfigBuilderTestCase.assertEquals((long)3000L, (long)((SimpleRetryConnectionStrategy)c.getConnectionStrategy()).getFrequency());
    }

    public void testGlobalEndpointConfig() {
        super.testGlobalEndpointConfig();
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint("fruitBowlEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint.getFilter());
        JXPathFilter filter = (JXPathFilter)endpoint.getFilter();
        AbstractConfigBuilderTestCase.assertEquals((String)"name", (String)filter.getExpression());
        AbstractConfigBuilderTestCase.assertEquals((String)"bar", (String)filter.getExpectedValue());
        AbstractConfigBuilderTestCase.assertEquals((Object)"http://foo.com", filter.getNamespaces().get("foo"));
    }

    public void testEndpointConfig() {
        super.testEndpointConfig();
        String endpointString = MuleManager.getInstance().lookupEndpointIdentifier("Test Queue", null);
        AbstractConfigBuilderTestCase.assertEquals((String)endpointString, (String)"test://test.queue");
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint("waterMelonEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent2");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor);
    }

    public void testInterceptorStacks() {
        super.testInterceptorStacks();
        UMOInterceptorStack stack = MuleManager.getInstance().lookupInterceptorStack("default");
        AbstractConfigBuilderTestCase.assertNotNull((Object)stack);
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)stack.getInterceptors().size());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(stack.getInterceptors().get(0) instanceof LoggingInterceptor));
        AbstractConfigBuilderTestCase.assertTrue((boolean)(stack.getInterceptors().get(1) instanceof TimerInterceptor));
    }

    public void testExceptionStrategy2() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getExceptionListener());
        AbstractConfigBuilderTestCase.assertEquals((Object)DefaultExceptionStrategy.class, descriptor.getExceptionListener().getClass());
    }

    public void testTransformerConfig() {
        super.testTransformerConfig();
        UMOTransformer t = MuleManager.getInstance().lookupTransformer("TestCompressionTransformer");
        AbstractConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractConfigBuilderTestCase.assertEquals((Object)t.getReturnClass(), (Object)String.class);
        AbstractConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        super.testModelConfig();
        UMOModel model = MuleManager.getInstance().lookupModel("main");
        AbstractConfigBuilderTestCase.assertTrue((boolean)model.isComponentRegistered("appleComponent"));
        AbstractConfigBuilderTestCase.assertTrue((boolean)model.isComponentRegistered("appleComponent2"));
    }

    public void testOutboundRouterConfig2() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getOutboundRouter());
        UMOOutboundRouterCollection router = descriptor.getOutboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)router.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)router.getRouters().size());
        UMOOutboundRouter route1 = (UMOOutboundRouter)router.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof FilteringOutboundRouter));
        UMOFilter filter = ((FilteringOutboundRouter)route1).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals((Object)String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        UMOOutboundRouter route2 = (UMOOutboundRouter)router.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route2 instanceof FilteringOutboundRouter));
        UMOFilter filter2 = ((FilteringOutboundRouter)route2).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter2);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter2 instanceof AndFilter));
        UMOFilter left = ((AndFilter)filter2).getLeftFilter();
        UMOFilter right = ((AndFilter)filter2).getRightFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)left);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(left instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"the quick brown (.*)", (String)((RegExFilter)left).getPattern());
        AbstractConfigBuilderTestCase.assertNotNull((Object)right);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(right instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"(.*) brown (.*)", (String)((RegExFilter)right).getPattern());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router.getCatchAllStrategy() instanceof TestCatchAllStrategy));
    }

    public void testInboundRouterConfig2() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getInboundRouter());
        UMOInboundRouterCollection messageRouter = descriptor.getInboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getRouters().size());
        UMOInboundRouter router = (UMOInboundRouter)messageRouter.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router instanceof SelectiveConsumer));
        SelectiveConsumer sc = (SelectiveConsumer)router;
        AbstractConfigBuilderTestCase.assertNotNull((Object)sc.getFilter());
        UMOFilter filter = sc.getFilter();
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals((Object)String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        UMOInboundRouter router2 = (UMOInboundRouter)messageRouter.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router2 instanceof IdempotentReceiver));
    }

    public void testThreadingConfig() throws MuleException {
        int defaultMaxBufferSize = 42;
        int defaultMaxThreadsActive = 17;
        int defaultMaxThreadsIdle = 3;
        int defaultThreadPoolExhaustedAction = 0;
        int defaultThreadTTL = 60001;
        int connectorMaxBufferSize = 2;
        int connectorThreadPoolExhaustedAction = 2;
        int componentMaxBufferSize = 6;
        int componentMaxThreadsActive = 12;
        int componentMaxThreadsIdle = 6;
        int componentThreadPoolExhaustedAction = 1;
        ThreadingProfile tp = MuleManager.getConfiguration().getDefaultThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        tp = MuleManager.getConfiguration().getComponentThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        AbstractConnector c = (AbstractConnector)MuleManager.getInstance().lookupConnector("dummyConnector");
        tp = c.getDispatcherThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)connectorMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)connectorThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        MuleDescriptor descriptor = (MuleDescriptor)MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent2");
        tp = descriptor.getThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)componentThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
    }

    public void testPoolingConfig() {
        PoolingProfile pp = MuleManager.getConfiguration().getPoolingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)10, (int)pp.getMaxActive());
        AbstractConfigBuilderTestCase.assertEquals((int)5, (int)pp.getMaxIdle());
        AbstractConfigBuilderTestCase.assertEquals((long)10001L, (long)pp.getMaxWait());
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)pp.getExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)pp.getInitialisationPolicy());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(pp.getPoolFactory() instanceof CommonsPoolFactory));
        MuleDescriptor descriptor = (MuleDescriptor)MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent2");
        pp = descriptor.getPoolingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)9, (int)pp.getMaxActive());
        AbstractConfigBuilderTestCase.assertEquals((int)6, (int)pp.getMaxIdle());
        AbstractConfigBuilderTestCase.assertEquals((long)4002L, (long)pp.getMaxWait());
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)pp.getExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)pp.getInitialisationPolicy());
    }

    public void testQueueProfileConfig() {
        QueueProfile qp = MuleManager.getConfiguration().getQueueProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)100, (int)qp.getMaxOutstandingMessages());
        AbstractConfigBuilderTestCase.assertTrue((boolean)qp.isPersistent());
        MuleDescriptor descriptor = (MuleDescriptor)MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        qp = descriptor.getQueueProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)100, (int)qp.getMaxOutstandingMessages());
        AbstractConfigBuilderTestCase.assertTrue((boolean)qp.isPersistent());
        descriptor = (MuleDescriptor)MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent2");
        qp = descriptor.getQueueProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)102, (int)qp.getMaxOutstandingMessages());
        AbstractConfigBuilderTestCase.assertFalse((boolean)qp.isPersistent());
    }

    public void testEndpointProperties() throws Exception {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent2");
        MuleEndpoint inEndpoint = (MuleEndpoint)descriptor.getInboundRouter().getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)inEndpoint.getCreateConnector());
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getProperties());
        AbstractConfigBuilderTestCase.assertEquals((Object)"Prop1", inEndpoint.getProperties().get("testEndpointProperty"));
    }

    public void testTransactionConfig() throws Exception {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("appleComponent2");
        UMOEndpoint inEndpoint = descriptor.getInboundRouter().getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertNull((Object)descriptor.getOutboundEndpoint());
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)descriptor.getOutboundRouter().getRouters().size());
        UMOEndpoint outEndpoint = (UMOEndpoint)((UMOOutboundRouter)descriptor.getOutboundRouter().getRouters().get(0)).getEndpoints().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)outEndpoint);
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getTransactionConfig());
        AbstractConfigBuilderTestCase.assertEquals((byte)1, (byte)inEndpoint.getTransactionConfig().getAction());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(inEndpoint.getTransactionConfig().getFactory() instanceof TestTransactionFactory));
        AbstractConfigBuilderTestCase.assertNull((Object)inEndpoint.getTransactionConfig().getConstraint());
    }

    public void testEnvironmentProperties() {
        Map props = MuleManager.getInstance().getProperties();
        AbstractConfigBuilderTestCase.assertNotNull((Object)props);
        AbstractConfigBuilderTestCase.assertNotNull(props.get("doCompression"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"true", props.get("doCompression"));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("beanProperty1"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"this was set from the manager properties!", props.get("beanProperty1"));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("OS Version"));
    }
}

