/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.model.streaming.StreamingService;
import org.mule.tck.functional.EventCallback;
import org.mule.umo.UMOEventContext;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public class FunctionalStreamingTestComponent
implements StreamingService {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private static AtomicInteger count = new AtomicInteger(0);
    private int number = count.incrementAndGet();
    public static final int STREAM_SAMPLE_SIZE = 4;
    public static final int STREAM_BUFFER_SIZE = 4096;
    private EventCallback eventCallback;
    private String summary = null;
    private long targetSize = -1L;

    public FunctionalStreamingTestComponent() {
        this.logger.debug((Object)("creating " + this.toString()));
    }

    public void setEventCallback(EventCallback eventCallback, long targetSize) {
        this.logger.debug((Object)("setting callback: " + eventCallback + " in " + this.toString()));
        this.eventCallback = eventCallback;
        this.targetSize = targetSize;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getNumber() {
        return this.number;
    }

    public void call(InputStream in, OutputStream unused, UMOEventContext context) throws Exception {
        try {
            this.logger.debug((Object)("arrived at " + this.toString()));
            byte[] startData = new byte[4];
            int startDataSize = 0;
            byte[] endData = new byte[4];
            int endDataSize = 0;
            int endRingPointer = 0;
            long streamLength = 0L;
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while (bytesRead >= 0) {
                int i;
                bytesRead = in.read(buffer);
                if (bytesRead <= 0) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("read " + bytesRead + " bytes"));
                }
                streamLength += (long)bytesRead;
                int startOfEndBytes = 0;
                for (i = 0; startDataSize < 4 && i < bytesRead; ++i) {
                    startData[startDataSize++] = buffer[i];
                    ++startOfEndBytes;
                }
                for (i = startOfEndBytes = Math.max(startOfEndBytes, bytesRead - 4); i < bytesRead; ++i) {
                    ++endDataSize;
                    endData[endRingPointer++ % 4] = buffer[i];
                }
                if (streamLength < this.targetSize) continue;
                this.doCallback(startData, startDataSize, endData, endDataSize, endRingPointer, streamLength, context);
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            throw e;
        }
    }

    private void doCallback(byte[] startData, int startDataSize, byte[] endData, int endDataSize, int endRingPointer, long streamLength, UMOEventContext context) throws Exception {
        StringBuffer result = new StringBuffer("Received stream");
        result.append("; length: ");
        result.append(streamLength);
        result.append("; '");
        for (int i = 0; i < startDataSize; ++i) {
            result.append((char)startData[i]);
        }
        int endSize = Math.min(endDataSize, 4);
        if (endSize > 0) {
            result.append("...");
            for (int i = 0; i < endSize; ++i) {
                result.append((char)endData[(endRingPointer + i) % 4]);
            }
        }
        result.append("'");
        this.summary = result.toString();
        String msg = StringMessageUtils.getBoilerPlate((String)("Message Received in component: " + context.getComponentDescriptor().getName() + ". " + this.summary + "\n callback: " + this.eventCallback), (char)'*', (int)80);
        this.logger.info((Object)msg);
        if (this.eventCallback != null) {
            this.eventCallback.eventReceived(context, this);
        }
    }

    public String toString() {
        return ClassUtils.getSimpleName(this.getClass()) + "/" + this.number;
    }
}

