/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.test.oauth.TestOAuthConnection;

@MediaType(value="text/plain")
@Alias(value="poller")
public class TestOAuthRefreshPollingSource
extends PollingSource<String, String> {
    public static final String SOURCE_ITEM_PAYLOAD = "Item payload!";
    public static final String SOURCE_ITEM_ATTRIBUTE = "Item attribute!";
    @Connection
    private ConnectionProvider<TestOAuthConnection> connectionProvider;

    protected void doStart() throws MuleException {
    }

    protected void doStop() {
    }

    public void poll(PollContext<String, String> pollContext) {
        TestOAuthConnection testOAuthConnection = null;
        try {
            testOAuthConnection = (TestOAuthConnection)this.connectionProvider.connect();
        }
        catch (ConnectionException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        if (!testOAuthConnection.getState().getState().getAccessToken().contains("refreshed")) {
            pollContext.onConnectionException(new ConnectionException((Throwable)new AccessTokenExpiredException("Token is expired!")));
            return;
        }
        pollContext.accept(pollItem -> pollItem.setResult(Result.builder().output((Object)SOURCE_ITEM_PAYLOAD).attributes((Object)SOURCE_ITEM_ATTRIBUTE).build()));
        this.connectionProvider.disconnect((Object)testOAuthConnection);
    }

    public void onRejectedItem(Result<String, String> result, SourceCallbackContext callbackContext) {
    }
}

