/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.test.oauth.TestOAuthConnection;

@MediaType(value="text/plain")
@Alias(value="listener")
public class TestOAuthRefreshSource
extends Source<String, String> {
    public static final String SOURCE_ITEM_PAYLOAD = "Item payload!";
    public static final String SOURCE_ITEM_ATTRIBUTE = "Item attribute!";
    @Inject
    private SchedulerService schedulerService;
    private Scheduler executor;
    private ScheduledFuture<?> scheduledFuture;
    @Connection
    private ConnectionProvider<TestOAuthConnection> connectionProvider;
    private TestOAuthConnection connection;

    public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        this.connection = (TestOAuthConnection)this.connectionProvider.connect();
        this.executor = this.schedulerService.cpuLightScheduler();
        this.scheduledFuture = this.executor.scheduleAtFixedRate(() -> this.dispatchItem(sourceCallback), 2000L, 500L, TimeUnit.MILLISECONDS);
    }

    private void dispatchItem(SourceCallback<String, String> sourceCallback) {
        if (!this.connection.getState().getState().getAccessToken().contains("refreshed")) {
            sourceCallback.onConnectionException(new ConnectionException((Throwable)new AccessTokenExpiredException("Token is expired!")));
            return;
        }
        sourceCallback.handle(Result.builder().output((Object)SOURCE_ITEM_PAYLOAD).attributes((Object)SOURCE_ITEM_ATTRIBUTE).build());
    }

    public void onStop() {
        if (this.executor != null && this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.executor.stop();
        }
        if (this.connection != null && this.connectionProvider != null) {
            this.connectionProvider.disconnect((Object)this.connection);
        }
    }
}

